/******************************************************************************* 
 *  usbHost.h
 *  2025.7.13  Suwa-Koubou
 */

#ifndef USBHOST_H
#define	USBHOST_H

#include <xc.h>

/*------------------------------------------------------------------------------
     prototype
 -----------------------------------------------------------------------------*/

// *** USB HOST core module ****************************************
extern int  isUsbConnect(void);
extern void usb_host_init(void);
extern void dump_descriptor(uint8_t *p, uint16_t len);

// *** USB HOST class driver *************************************
//  Audio Midi driver 
extern int get_nums_midi_device(void);
extern int usb_midi_read(int dev_no, uint8_t *buff, uint16_t buff_size);
extern int usb_midi_write(int dev_no, uint8_t *data, uint16_t data_size);

//  HID Keyboard driver 
extern int  usb_keyboard_read(int dev_no, uint8_t *buff, uint16_t buff_size);
extern int  get_nums_keyboard_device(void);
extern int  usb_keyboard_set_report(int dev_no, uint8_t led_ctrl);
extern int  usb_keyboard_set_protocol(int dev_no, uint8_t protocol);

//  HID mouse driver 
extern int  usb_mouse_read(int dev_no, uint8_t *buff, uint16_t buff_size);
extern int  get_nums_mouse_device(void);
extern int  usb_mouse_set_protocol(int dev_no, uint8_t protocol);

//  HID generic driver 
extern int  usb_hid_generic_read(int dev_no, uint8_t *buff, uint16_t buff_size);
extern int  usb_hid_generic_write(int dev_no, uint8_t *data, uint16_t data_size);
extern int  get_nums_hid_generic_device(void);

//  CDC class driver 
extern int get_nums_serial_device(void);
extern int usb_serial_read(int dev_no, uint8_t *buff, uint16_t buff_size);
extern int usb_serial_write(int dev_no, uint8_t *data, uint16_t data_size);
extern int set_serial_port_parameter(int dev_no, int32_t *param);
extern int get_serial_port_parameter(int dev_no, int32_t *param);
extern int set_serial_port_state(int dev_no, uint8_t ctrl);

// MSC driver
extern int get_nums_msc_device(void);
extern int usb_msc_sector_read(int dev_no, uint32_t read_sector, uint8_t *buff);
extern int usb_msc_sector_write(int dev_no, uint32_t write_sector, uint8_t *data);
extern int usb_msc_test_unit_ready(int dev_no);
extern uint32_t usb_msc_capacity_read(int dev_no);
extern int usb_msc_request_sense(int dev_no);


#endif
/*** end of file **************************************************************/