/*******************************************************************************
    delay.c
    PIC32MZ2048EFH100
*/

#include	"HardwareProfile.h"
#include	"delay.h"
#include    <xc.h>

/*------------------------------------------------------------------------------
	delay routines    from  https://www.aidanmoche.com
------------------------------------------------------------------------------*/

void delay_us(unsigned int us)
{    
    // Convert microseconds us into how many clock ticks it will take
    us *= GetSystemClock() / 1000000 / 2; // Core Timer updates every 2 ticks

    _CP0_SET_COUNT(0); // Set Core Timer count to 0

    while (us > _CP0_GET_COUNT()); // Wait until Core Timer count reaches the number we calculated earlier
}

void delay_ms(unsigned int ms)
{
    delay_us(ms * 1000);
}


/*** end of delay.c ***********************+++++++*****************************/
