/************************************************************
	debug.h
	debug print macro
************************************************************/

#ifndef __DEBUG_H_
#define __DEBUG_H_

// to PC, UART communication macros
#define USEUART2
#include "uart2.h"

#define DEBUG
#ifdef DEBUG
  #if defined(USEUART1)
    #define   putstr(x)      UART1PrintString(x)
	#define   putdata(x,y)   UART1PutData(x,y)
	#define   inkey()        UART1IsPressed()
	#define   getch()        UART1GetChar()
	#define   getdata(x,y)   UART1GetData(x,y)
	#define   getstr(x,y)    UART1GetString(x,y)
    #define   puthex(x)      UART1PutHex(x)
    #define   putword(x)     UART1PutHexWord(x)
    #define   putdword(x)    UART1PutHexDWord(x)
    #define   putch(x)       UART1PutChar(x)
    #define   putdec(x)      UART1PutDec(x)
  #elif defined(USEUART2)
    #define   putstr(x)      UART2PrintString(x)
	#define   putdata(x,y)   UART2PutData(x,y)
	#define   inkey()        UART2IsPressed()
	#define   getch()        UART2GetChar()
	#define   getdata(x,y)   UART2GetData(x,y)
	#define   getstr(x,y)    UART2GetString(x,y)
    #define   puthex(x)      UART2PutHex(x)
    #define   putword(x)     UART2PutHexWord(x)
    #define   putdword(x)    UART2PutHexDWord(x)
    #define   putch(x)       UART2PutChar(x)
    #define   putdec(x)      UART2PutDec(x)
  #else
    #error  not define UART 
  #endif
  #define     putcrlf()      putstr("\r\n")
#else
  #if defined(USEUART1)
	#define   inkey()        UART1IsPressed()
	#define   getch()        UART1GetChar()
	#define   getdata(x,y)   UART1GetData(x,y)
	#define   getstr(x,y)    UART1GetString(x,y)
  #elif defined(USEUART2)
	#define   inkey()        UART2IsPressed()
	#define   getch()        UART2GetChar()
	#define   getdata(x,y)   UART2GetData(x,y)
	#define   getstr(x,y)    UART2GetString(x,y)
  #endif
  #define   putstr(x)
  #define   putdata(x,y)
  #define   puthex(x)
  #define   putword(x)
  #define   putdword(x)
  #define   putch(x)
  #define   putdec(x)
  #define   putcrlf()
#endif

#endif // __DEBUG_H_

/*** end of debug.h *****************************************/
