/***********************************************************************

	mz1200.h

	2013/10/20  S.Suwa http://www.suwa-koubou.jp	
***********************************************************************/

#ifndef _MZ1200_H
#define	_MZ1200_H

#define	MD_MZ80A     0  // europian MZ machine
#define MD_MZ1200    1  // japan MZ machine

extern int           machine_mode;
extern void          resetMZ1200(void);
extern unsigned char fetch(unsigned short adr);
extern void	         store(unsigned short adr, unsigned char  val);
extern void	         store2b(unsigned short adr, unsigned char  vh, unsigned char  vl);
extern unsigned char ramRead(unsigned short addr);
extern void          ramWrite(unsigned short addr, unsigned char data);
extern unsigned char in(unsigned char dummy, unsigned short adr);
extern unsigned int  out(unsigned char dummy, unsigned char adr, unsigned char val);

extern int           setClock;     // ClockCount set flag
extern int           scrnRvrs;     // screen reverse flag
extern int           v_gate;       // screen blank flag
extern int           play_button;  // casset play button 0x10=ON, 0x00=OFF
extern unsigned char v_blank;      // vertical blanking flag 
extern unsigned char RAM[64*1024]; // 64Kbyte RAM (0000-FFFF)
extern unsigned char cgROM[8][256]; // 'SBDBT32' use NTSC version
extern unsigned char Vrvs[1000];    // VRAM reverse flg 40x25=1000  2022/07 

#endif
