/***************************************************************

	key.h

	2013/10/18  S.Suwa http://www.suwa-koubou.jp	
***************************************************************/

#ifndef	_KEY_H
#define	_KEY_H

#include "GenericTypeDefs.h"

#define UP_PRESS      0x52
#define DOWN_PRESS    0x51
#define ENTER_PRESS   0x28
#define ESCAPE_PRESS  0x29
#define BREAK_PRESS   0x48

#define LEFT_CTRL_PRESS   0x0100 // effect MZ-80A mode
#define RIGHT_CTRL_PRESS  0x1000 // efeect MZ-80A mode
#define LEFT_SHIFT_PRESS  0x0200
#define RIGHT_SHIFT_PRESS 0x2000
#define LEFT_ALT_PRESS    0x0400
#define RIGHT_ALT_PRESS   0x4000
#define NUMLOCK_PRESS     0x0800
#define CAPSLOCK_PRESS    0x8000

// NOT SHIFTED key range
#define A_PRESS      0x04
#define NZero_PRESS  0x62
#define BACKSLASH_PRESS 0x87
#define YEN_PRESS    0x89

// SHIFTED key range
#define EQUAL_PRESS   0x2D
#define QUEST_PRESS   0x38

// FunctionKey assign 
#define FKEY1_PRESS   0x3a  // INT 0  RST 0
#define FKEY2_PRESS   0x3b  // INT 1  RST 8
#define FKEY3_PRESS   0x3c  // INT 2  RST 10
#define FKEY4_PRESS   0x3d  // INT 2  RST 18
#define FKEY5_PRESS   0x3e  // INT 2  RST 20
#define FKEY6_PRESS   0x3f  // INT 2  RST 28
#define FKEY7_PRESS   0x40  // INT 2  RST 30
#define FKEY8_PRESS   0x41  // INT 2  RST 38
#define FKEY9_PRESS   0x42
#define FKEY10_PRESS  0x43  // PLAY/RECORD
#define FKEY11_PRESS  0x44  // cpu reset
#define FKEY12_PRESS  0x45  // NMI

// keybord.c
extern void keybord_init(void);
extern WORD keybord_read(void);
// key.c
extern unsigned char keymatrix[10];
extern void clear_keymatrix(void);
extern void keybord_scan(void);
extern int scan_inhibit;

#endif

/*** end of key.h *********************************************/
