/*******************************************************************************

    USB Host UVC Client Driver (Header File)

	S.Suwa        30-Jul-2012 First release
                   5-Apl-2013 update UVC_DATA_BUFFER

*******************************************************************************/

#ifndef __USB_HOST_UVC_H
#define __USB_HOST_UVC_H

/*------------------------------------------------------------------------------
	macro Constants
-------------------------------------------------------------------------------*/

// Video Class-Specific Request Codes
#define	RC_UNDEFIND	0
#define	SET_CUR		1
#define	GET_CUR		0x81
#define	GET_MIN		0x82
#define	GET_MAX		0x83
#define	GET_RES		0x84
#define	GET_LEN		0x85
#define	GET_INFO 	0x86
#define	GET_DEF		0x87

// DataType Codes 
#define	BOOLEAN		1
#define	bBITMAP		2
#define wBITMAP		3
#define	bSIGNED		4
#define	wSIGNED		5
#define	dwSIGNED	6
#define	bNUMBER		7
#define	wNUMBER		8
#define	dwNUMBER	9

// Image Format
#define	FMT_YUY2		0x00
#define	FMT_NV12		0x01
#define	FMT_MJPEG		0x02
#define	FMT_MPEG2TS		0x03
#define	FMT_DV			0x04
#define	FMT_UNKNOWN		0xff

// Control Codes
enum {
    // Interface Control
    UVC_APL_POWER_MODE = 0,
    UVC_APL_ERROR_CODE,
    // Camera Terminal Control
    UVC_APL_SCANNING,
    UVC_APL_AE_MODE,
    UVC_APL_AE_PRIORITY,
    UVC_APL_EXPOSURE_ABS,
    UVC_APL_EXPOSURE_REL,
    UVC_APL_FOCUS_ABS,
    UVC_APL_FOCUS_REL,
    UVC_APL_IRIS_ABS,
    UVC_APL_IRIS_REL,
    UVC_APL_ZOOM_ABS,
    UVC_APL_ZOOM_REL,
    UVC_APL_PANTILT_ABS,
    UVC_APL_PANTILT_REL,
    UVC_APL_ROLL_ABS,
    UVC_APL_ROLL_REL,
    UVC_APL_RESERVED1,
    UVC_APL_RESERVED2,
    UVC_APL_FOCUS_AUTO,
    UVC_APL_PRIVACY,
    // Selector Unit Control
    UVC_APL_INPUT_SELECT,
    // Processing Unit Control
    UVC_APL_BRIGHTNESS,
    UVC_APL_CONTRAST,
    UVC_APL_HUE,
    UVC_APL_SATURATION,
    UVC_APL_SHARPNESS,
    UVC_APL_GAMMA,
    UVC_APL_WB_TEMP,
    UVC_APL_WB_COMPO,
    UVC_APL_BACKLIGHT,
    UVC_APL_GAIN,
    UVC_APL_POWER_LINE,
    UVC_APL_HUE_AUTO,
    UVC_APL_WB_TEMP_AUTO,
    UVC_APL_WB_COMPO_AUTO,
    UVC_APL_MULTI,
    UVC_APL_MULTI_LIMIT,
    UVC_APL_ANALOG,
    UVC_APL_ANALOG_LOCK,
    // Video Streaming Control
    UVC_APL_PROBE,
    UVC_APL_COMMIT,
    UVC_APL_STILL_PROBE,
    UVC_APL_STILL_COMMIT,
    UVC_APL_STILL_IMAGE_TRIGGER,
    UVC_APL_STREAME_ERROR_CODE,
    UVC_APL_GENERATE_KEY_FRAME,
    UVC_APL_UPDATE_FRAME_SEGMENT,
    UVC_APL_SYNCH_DELAY,
};

// ==== UVC function error codes ===================
#define	UVC_SUCCESS		0
#define	UVC_FAIL		1
#define	UVC_INVALID		2
#define	UVC_UNSUPPORTED_CONTROL	3
#define	UVC_UNSUPPORTED_REQUEST	4
#define	UVC_UNSUPPORTED_FORMAT  5
#define	UVC_UNSUPPORTED_RESOLUTION  6
#define	UVC_TRUE		1
#define	UVC_FALSE		0

/*------------------------------------------------------------------------------
	Video Class Client Events
-------------------------------------------------------------------------------*/

#define EVENT_UVC_OFFSET   0
#define	EVENT_UVC_BASE     EVENT_USER_BASE   // new Add Class-defined event base
#define EVENT_UVC_ATTACH  (EVENT_UVC_BASE+EVENT_UVC_OFFSET+0)
#define EVENT_UVC_DETACH  (EVENT_UVC_BASE+EVENT_UVC_OFFSET+1)


/*------------------------------------------------------------------------------
	Type Definition
-------------------------------------------------------------------------------*/

// Frame information
typedef	struct	{
	BYTE	bFrameIndex;
	WORD	wWidth;
	WORD	wHeight;
	DWORD	dwFrameInterval;
} UVC_FRAME_INFO;

typedef struct	{
	BYTE	format;
	BYTE	bFormatIndex;
	BYTE	bNumFrames;
	UVC_FRAME_INFO *frame;
} UVC_FORMAT_INFO;


// UVC_DATA_BUFFER same ISOCHRONOUS_DATA_BUFFER see usb_host.h
//   5-Apl-2013 update
typedef	struct {
	BYTE	*buffer;
	WORD	length;
	BYTE	valid:1;
} UVC_DATA_BUFFER;


// UVC Camera State for Application
typedef enum
{
	CAMERA_DETACHED = 0,
	CAMERA_ATTACHED,
} CAMERA_STATE;


/*------------------------------------------------------------------------------
    Host Stack Interface Functions
-------------------------------------------------------------------------------*/
BOOL USBHostUVCInit(BYTE address, DWORD flags, BYTE clientDriverID);
BOOL USBHostUVCEventHandler(BYTE address, USB_EVENT event, void *data, DWORD size);

/*------------------------------------------------------------------------------
    Application interface Functions
-------------------------------------------------------------------------------*/
BYTE USBHostUVCDeviceAttached(void);
char *USBHostUVCGetControlName(BYTE control);
BYTE USBHostUVCGetControlValue(BYTE control, BYTE request, BYTE *data, BYTE *len, WORD *type);
BYTE USBHostUVCSetControlValue(BYTE control, BYTE request, BYTE *data, BYTE len);
BYTE USBHostUVCGetFormatCount(void);
BYTE USBHostUVCGetFormat(int number);
UVC_FRAME_INFO *USBHostUVCGetFrame(BYTE format_number, BYTE *numframes);
BYTE USBHostUVCSetFrame(BYTE format_number, WORD width, WORD height);
BYTE USBHostUVCStartFrameCapturing(void);
UVC_DATA_BUFFER *USBHostUVCGetFrameCapturing(void);
BYTE USBHostUVCStopFrameCapturing(void);

/*** end of usb_host_uvc.h ***********************************************/

#endif
