/*==================================================================================

	usb_config.h

    2012/7/31 S.Suwa    http://www.suwa-koubou.jp

===================================================================================*/

#include "Compiler.h"

#define USB_SUPPORT_HOST
#define USB_PING_PONG_MODE  USB_PING_PONG__FULL_PING_PONG

#define NUM_TPL_ENTRIES getNumTPLs()	// getNumTPLs() function was defined in usb_config.c. 

#define USB_SUPPORT_INTERRUPT_TRANSFERS
//#define USB_SUPPORT_BULK_TRANSFERS	     // UVC webcam device doesn't use bulk transfer.
#define USB_SUPPORT_ISOCHRONOUS_TRANSFERS    // UVC webcam device use isochoronous transfer.

#define USB_ENABLE_TRANSFER_EVENT
#define USB_ENABLE_ISOC_TRANSFER_EVENT 

#define USB_NUM_CONTROL_NAKS 20
#define USB_NUM_INTERRUPT_NAKS 3
#define USB_NUM_BULK_NAKS 20000

#define USB_INITIAL_VBUS_CURRENT (100/2)
#define USB_INSERT_TIME (250+1)
#define USB_HOST_APP_EVENT_HANDLER        USB_ApplicationEventHandler // in Application main.c
#define USB_HOST_APP_DATA_EVENT_HANDLER   // USB_ApplicationDataEventHandler // in Application main.c

// I willn't use data event handler routine.
#ifdef USB_HOST_APP_DATA_EVENT_HANDLER
	#undef USB_HOST_APP_DATA_EVENT_HANDLER
#endif


#define USBTasks()                  \
    {                               \
        USBHostTasks();             \
    }

#define USBInitialize(x)            \
    {                               \
        USBHostInit(x);             \
    }

// function prototype, get Numbers of TPL
BYTE getNumTPLs(void);

/*** end of usb_config.h ************************************************************/
