/*********************************************************************

	tskchg.c

	This module provide none preenptive multitasking.

	2013/6/23 S.Suwa  http://www.suwa-koubou.jp
**********************************************************************/

#include	<p32xxxx.h>
#include	"tskchg.h"

/*** definition ******************************************************/
typedef unsigned long UINT32;

/*** global variable *************************************************/
UINT32 volatile _curtsk;
UINT32 volatile _tcb[TSK_MAX];
UINT32 volatile *_stckptr[TSK_MAX];
UINT32 _stck[TSK_MAX-1][STKSZ/sizeof(UINT32)];


/*-----------------------------------------------------------------------
	initilaize task change system
-----------------------------------------------------------------------*/

void tsk_init(void)
{
	int	i;

	// clear task control block
	for(i = 0; i < TSK_MAX; i++){
		_tcb[i] = TSK_NOEXIST;
	}
	_curtsk = 0;
	_tcb[0] = TSK_EXIST;	// tsk_id zero is main() task.
}


/*-----------------------------------------------------------
	task entry
	stack_size in bytes
------------------------------------------------------------*/

int	tsk_entry(void (*task)(void), int stack_size)
{
    UINT32 *pstk, sr_val, gp_val;
	int	tsk_id;

    for(tsk_id = 1; tsk_id < TSK_MAX; tsk_id++){
        if(_tcb[tsk_id] == TSK_NOEXIST) break;
    }

    if(tsk_id >= TSK_MAX){
        return TSK_FULL;
    }

    _tcb[tsk_id] = TSK_EXIST;
	//pstk =&(_stck[tsk_id-1][STKSZ/sizeof(UINT32)-1]);
	pstk =&(_stck[tsk_id][STKSZ/sizeof(UINT32)-1]);

    asm volatile("mfc0   %0,$12"   : "=r"(sr_val));
    sr_val |= 0x00000003;
    asm volatile("addi   %0,$28,0" : "=r"(gp_val));

     pstk--;                        /* Ensure that a free entry is being referenced */
    *pstk--  = (UINT32)task;        /* GPR[31] */
    *pstk--  = (UINT32)0x30303030;  /* GPR[30] */
    *pstk--  = gp_val;              /* GPR[28] */
    *pstk--  = (UINT32)0x27272727;  /* GPR[27] */
    *pstk--  = (UINT32)0x26262626;  /* GPR[26] */
    *pstk--  = (UINT32)0x25252525;  /* GPR[25] */
    *pstk--  = (UINT32)0x24242424;  /* GPR[24] */
    *pstk--  = (UINT32)0x23232323;  /* GPR[23] */
    *pstk--  = (UINT32)0x22222222;  /* GPR[22] */
    *pstk--  = (UINT32)0x21212121;  /* GPR[21] */
    *pstk--  = (UINT32)0x20202020;  /* GPR[20] */
    *pstk--  = (UINT32)0x19191919;  /* GPR[19] */
    *pstk--  = (UINT32)0x18181818;  /* GPR[18] */
    *pstk--  = (UINT32)0x17171717;  /* GPR[17] */
    *pstk--  = (UINT32)0x16161616;  /* GPR[16] */
    *pstk--  = (UINT32)0x15151515;  /* GPR[15] */
    *pstk--  = (UINT32)0x14141414;  /* GPR[14] */
    *pstk--  = (UINT32)0x13131313;  /* GPR[13] */
    *pstk--  = (UINT32)0x12121212;  /* GPR[12] */
    *pstk--  = (UINT32)0x11111111;  /* GPR[11] */
    *pstk--  = (UINT32)0x10101010;  /* GPR[10] */
    *pstk--  = (UINT32)0x09090909;  /* GPR[9]  */
    *pstk--  = (UINT32)0x08080808;  /* GPR[8]  */
    *pstk--  = (UINT32)0x07070707;  /* GPR[7]  */
    *pstk--  = (UINT32)0x06060606;  /* GPR[6]  */
    *pstk--  = (UINT32)0x05050505;  /* GPR[5]  */
    *pstk--  = (UINT32)0x00000000;  /* GPR[4] (or, equivalently, a0) is used for arguments  */
    *pstk--  = (UINT32)0x03030303;  /* GPR[3]  */
    *pstk--  = (UINT32)0x02020202;  /* GPR[2]  */
    *pstk--  = (UINT32)0x01010101;  /* GPR[1]  */
    *pstk--  = (UINT32)0x00000000;  /* Special Purpose HI Register */
    *pstk--  = (UINT32)0x00000000;  /* Special Purpose LO Register */
    *pstk--  = (UINT32)task;        /* EPC */
    *pstk--  = sr_val;              /* SR  */

	_stckptr[tsk_id] = pstk;

	return tsk_id;
}


/*---------------------------------------------------------------------
	task exit
---------------------------------------------------------------------*/

void tsk_exit(void)
{
	_tcb[_curtsk] = TSK_NOEXIST;
	tsk_chg(0);	// tsk_chg() not return
}


/*---------------------------------------------------------------------
	task delete
---------------------------------------------------------------------*/

void tsk_delete(int tsk_id)
{
	if(tsk_id < 1 || tsk_id >= TSK_MAX) return;
	_tcb[tsk_id] = TSK_NOEXIST;
}


#if 0

/*---------------------------------------------------------------------
	task xchange
@@@@AZuvOQlɁARpCʂ̃AZuR[h𒲍邽߂
@@@R[hłÅ֐́AS̃S~łB
---------------------------------------------------------------------*/

void tsk_xchg(UINT32 tsk_id)
{
	UINT32	volatile *sp;

	sp = (UINT32 *)0x12345678;

	_stckptr[_curtsk] = sp;

	if(tsk_id){
		_curtsk = tsk_id;
		goto _next_chk;
	}


_next_tsk:
	_curtsk++;
	if(_curtsk >= TSK_MAX){
		_curtsk = 0;
	}
_next_chk:
	if(_tcb[_curtsk] == TSK_NOEXIST){
		goto _next_tsk;
	}

	sp = _stckptr[_curtsk];


}

#endif


/*** end of tskchg.c *************************************************/

