/************************************************************************************

	tsk_chg.S

	coded by S.Suwa, hint  Micrium uC-OSII

	2013/6/23  http://www.suwa-koubou.jp
************************************************************************************/

#include <p32xxxx.h>

    .set noreorder
    .set noat

	.extern  _curtsk
    .extern  _tcb
    .extern  _stckptr

    .global  tsk_chg

	.equ    TSK_MAX,        4
	.equ    TSK_EXIST,      1
	.equ    TSK_NOEXIST,    0

	.equ    OFFSET_SR,      4
	.equ    OFFSET_EPC,     OFFSET_SR    + 4
	.equ    OFFSET_LO,      OFFSET_EPC   + 4
	.equ    OFFSET_HI,      OFFSET_LO    + 4
	.equ    OFFSET_GPR1,    OFFSET_HI    + 4
	.equ    OFFSET_GPR2,    OFFSET_GPR1  + 4
	.equ    OFFSET_GPR3,    OFFSET_GPR2  + 4
	.equ    OFFSET_GPR4,    OFFSET_GPR3  + 4
	.equ    OFFSET_GPR5,    OFFSET_GPR4  + 4
	.equ    OFFSET_GPR6,    OFFSET_GPR5  + 4
	.equ    OFFSET_GPR7,    OFFSET_GPR6  + 4
	.equ    OFFSET_GPR8,    OFFSET_GPR7  + 4
	.equ    OFFSET_GPR9,    OFFSET_GPR8  + 4
	.equ    OFFSET_GPR10,   OFFSET_GPR9  + 4
	.equ    OFFSET_GPR11,   OFFSET_GPR10 + 4
	.equ    OFFSET_GPR12,   OFFSET_GPR11 + 4
	.equ    OFFSET_GPR13,   OFFSET_GPR12 + 4
	.equ    OFFSET_GPR14,   OFFSET_GPR13 + 4
	.equ    OFFSET_GPR15,   OFFSET_GPR14 + 4
	.equ    OFFSET_GPR16,   OFFSET_GPR15 + 4
	.equ    OFFSET_GPR17,   OFFSET_GPR16 + 4
	.equ    OFFSET_GPR18,   OFFSET_GPR17 + 4
	.equ    OFFSET_GPR19,   OFFSET_GPR18 + 4
	.equ    OFFSET_GPR20,   OFFSET_GPR19 + 4
	.equ    OFFSET_GPR21,   OFFSET_GPR20 + 4
	.equ    OFFSET_GPR22,   OFFSET_GPR21 + 4
	.equ    OFFSET_GPR23,   OFFSET_GPR22 + 4
	.equ    OFFSET_GPR24,   OFFSET_GPR23 + 4
	.equ    OFFSET_GPR25,   OFFSET_GPR24 + 4
	.equ    OFFSET_GPR26,   OFFSET_GPR25 + 4
	.equ    OFFSET_GPR27,   OFFSET_GPR26 + 4
	.equ    OFFSET_GPR28,   OFFSET_GPR27 + 4
	.equ    OFFSET_GPR30,   OFFSET_GPR28 + 4
	.equ    OFFSET_GPR31,   OFFSET_GPR30 + 4 
	.equ    CTX_SIZE,       OFFSET_GPR31 + 4

/*************************************************************
 *	void tsk_chg(int tsk_id);
 *    if tsk_id is zero then switched next task.
 *    if tsk_id not zero then switched tsk_id task.
 *************************************************************/

    .ent tsk_chg
tsk_chg:

    /* Adjust the stack pointer */                      
    addi  $29, $29, - CTX_SIZE

    /* Save the General Purpose Registers  */
    sw    $1,  OFFSET_GPR1($29) 
    sw    $2,  OFFSET_GPR2($29)
    sw    $3,  OFFSET_GPR3($29)
    sw    $4,  OFFSET_GPR4($29)
    sw    $5,  OFFSET_GPR5($29)
    sw    $6,  OFFSET_GPR6($29)
    sw    $7,  OFFSET_GPR7($29)
    sw    $8,  OFFSET_GPR8($29)
    sw    $9,  OFFSET_GPR9($29)
    sw    $10, OFFSET_GPR10($29)
    sw    $11, OFFSET_GPR11($29)
    sw    $12, OFFSET_GPR12($29)
    sw    $13, OFFSET_GPR13($29)
    sw    $14, OFFSET_GPR14($29)
    sw    $15, OFFSET_GPR15($29)
    sw    $16, OFFSET_GPR16($29)
    sw    $17, OFFSET_GPR17($29)
    sw    $18, OFFSET_GPR18($29)
    sw    $19, OFFSET_GPR19($29)
    sw    $20, OFFSET_GPR20($29)
    sw    $21, OFFSET_GPR21($29)
    sw    $22, OFFSET_GPR22($29)
    sw    $23, OFFSET_GPR23($29)
    sw    $24, OFFSET_GPR24($29)
    sw    $25, OFFSET_GPR25($29)
    sw    $26, OFFSET_GPR26($29)
    sw    $27, OFFSET_GPR27($29)
    sw    $28, OFFSET_GPR28($29)
    sw    $30, OFFSET_GPR30($29)
    sw    $31, OFFSET_GPR31($29)

    /* Save the contents of the LO and HI registers  */
    mflo  $8
    mfhi  $9
    sw    $8,  OFFSET_LO($29)
    sw    $9,  OFFSET_HI($29)

	/* store Return Address for EPC restore */
    sw    $31, OFFSET_EPC($29)

	/* Save the Status register */
    mfc0  $8,  $12, 0                          
	ori   $8,  $8, 0x03		/* set EXL exception level bit(1), and IE bit(0) */
    sw    $8,  OFFSET_SR($29)
                              
	/************************************************************************/

	/* saved stack pointer of current task */
	/* _stckptr[_curtsk] = $29(sp) */
	la	  v1,  _curtsk
	lw    v1,  (v1)
	la	  v0,  _stckptr
 	sll   v1,  v1,2
	addu  v0,  v1,v0
	sw    $29, (v0)

	/* if(tsk_id == 0) goto __next_tsk */
	beq   $4, zero, __next_tsk
	nop

	/* _curtsk = tsk_id; */
	la    v1,  _curtsk
	sw    $4,  (v1)
	j    __next_01
	nop	

	/*** search next ready task ********************/
__next_tsk:
	nop

	/* _curtsk++ */
	la    v1,  _curtsk
	lw    v1,  (v1)
	addiu v1,  v1,1
	la    v0,  _curtsk
	sw    v1,  (v0)

	/* if(_curtsk >= TSK_MAX){
		_curtsk = 0;
	   } */
	la	  v0,  _curtsk
	lw    v0,  (v0)
	sltiu v0,  v0, TSK_MAX
	bne   v0,  zero,__next_01
	nop
	la    v0,   _curtsk
	sw    zero, (v0)
__next_01:
	/*	if(_tcb[_curtsk] != NOEXIST)
			goto __next_tsk
	*/
	la    v1,  _curtsk
	lw    v1,  (v1)
	la	  v0,  _tcb
 	sll   v1,  v1,2
	addu  v0,  v1,v0
	lw    v0,  (v0)
	beq   v0,  zero,__next_tsk
	nop

	/*** changed stack to next task ****************/
	/* $29(sp) = _stckptr[_curtsk] */

	la	  v1,  _curtsk
	lw    v1,  (v1)
	la	  v0,  _stckptr
 	sll   v1,  v1,2
	addu  v0,  v1,v0
	lw    $29, (v0)

	/*** restore context ***************************/

    /* Restore the Status register  */
    lw    $8,  OFFSET_SR($29)
    mtc0  $8,  $12, 0 

	/* Restore the EPC */
    lw    $8,  OFFSET_EPC($29)     
    mtc0  $8,  $14, 0

    /* Restore the contents of the LO and HI registers */
    lw    $8,  OFFSET_LO($29)
    lw    $9,  OFFSET_HI($29)
    mtlo  $8
    mthi  $9

    /* Restore the General Purpose Registers  */
    lw    $31, OFFSET_GPR31($29)
    lw    $30, OFFSET_GPR30($29)
    lw    $28, OFFSET_GPR28($29)
    lw    $27, OFFSET_GPR27($29)
    lw    $26, OFFSET_GPR26($29)
    lw    $25, OFFSET_GPR25($29)
    lw    $24, OFFSET_GPR24($29)
    lw    $23, OFFSET_GPR23($29)
    lw    $22, OFFSET_GPR22($29)
    lw    $21, OFFSET_GPR21($29)
    lw    $20, OFFSET_GPR20($29)
    lw    $19, OFFSET_GPR19($29)
    lw    $18, OFFSET_GPR18($29)
    lw    $17, OFFSET_GPR17($29)
    lw    $16, OFFSET_GPR16($29)
    lw    $15, OFFSET_GPR15($29)
    lw    $14, OFFSET_GPR14($29)
    lw    $13, OFFSET_GPR13($29)
    lw    $12, OFFSET_GPR12($29)
    lw    $11, OFFSET_GPR11($29)
    lw    $10, OFFSET_GPR10($29)
    lw    $9,  OFFSET_GPR9($29)
    lw    $8,  OFFSET_GPR8($29)
    lw    $7,  OFFSET_GPR7($29)
    lw    $6,  OFFSET_GPR6($29)
    lw    $5,  OFFSET_GPR5($29)
    lw    $4,  OFFSET_GPR4($29)
    lw    $3,  OFFSET_GPR3($29)
    lw    $2,  OFFSET_GPR2($29)
    lw    $1,  OFFSET_GPR1($29)

    /* Adjust the stack pointer */   
    addi  $29, $29, CTX_SIZE

	/* Resume execution in new task */
    eret                  

    .end tsk_chg

