/*****************************************************************
	s1d13781.h

	2013/7/16  S.Suwa http://www.suwa-koubou.jp	
*****************************************************************/

#ifndef __S1D13781_H
#define	__S1D13781_H

#include "HardwareProfile.h"
#include "GenericTypeDefs.h"

// select host interface
#if defined(__PIC24FJ64GB002__)
	#define USE_SPI_INTERFACE

#elif defined(__32MX220F032B__)
	#define USE_SPI_INTERFACE

#elif defined(__32MX695F512H__)
  #ifdef REPIC32SD_BOARD
	#define	USE_INDIRECT8_INTERFACE
  #else
	#define USE_SPI_INTERFACE
  #endif

#elif defined(__PIC24FJ256GB106__)
	#define	USE_INDIRECT8_INTERFACE
#else
	#error Choose processor
#endif

// use dump routines for debug
//#define USE_DUMP_ROUTINES

// image resolution size
#define	VGA_WIDTH       640
#define	VGA_HEIGHT      480
#define	QVGA_WIDTH      320
#define	QVGA_HEIGHT     240
#define	QQVGA_WIDTH     160
#define	QQVGA_HEIGHT    120

#define	VGA_SIZE		(640l*480l)
#define	QVGA_SIZE       (320l*240l)
#define	QQVGA_SIZE      (160*120)

#define	MAIN_LAYER  0
#define	PIP_LAYER   1

#define	tOFF        0
#define	tON         1

#define	MAIN_VRAM_ADR	0x00000UL		// 320 * 240 * 2(RGB565) = 0x25800
#define	PIP_VRAM_ADR	0x25800UL
#define	REG_ADR			0x60800UL

typedef unsigned short LOCATE;

extern	unsigned short wRGB565[8];
#define	cBLACK    (wRGB565[0])
#define	cRED      (wRGB565[1])
#define	cGREEN    (wRGB565[2])
#define	cYELLOW   (wRGB565[3])
#define	cBLUE     (wRGB565[4])
#define	cMAGENTA  (wRGB565[5])
#define	cCYAN     (wRGB565[6])
#define	cWHITE    (wRGB565[7])

extern	void	lcdc_initialize(void);
extern	void	vram_testbar_write(int layer);
extern	void	select_display_layer(int layer);
extern	void	set_pip_transparency(int sw);
extern	void	set_pip_blinking(int sw);

extern	void	lcd_clear(int layer, unsigned short color);
extern	void    lcd_putstr(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str);
extern	void    lcd_putstr_wide(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str);

extern	unsigned char	read_byte(long addr);
extern	void	read_byte_block(long addr, unsigned char *buf, unsigned int size);
extern	void	write_byte(long addr, unsigned char d);
extern	void	write_byte_block(long addr, unsigned char *buf, unsigned int size);

extern	unsigned short	read_word(long addr);
extern	void	read_word_block(long addr, unsigned short *buf, unsigned int size);
extern	void	write_word(long addr, unsigned short d);
extern	void	write_word_block(long addr, unsigned short *buf, unsigned int size);

#ifdef USE_DUMP_ROUTINES
	extern	void	register_byte_dump(void);
	extern	void	register_word_dump(void);
	extern	void	vram_dump(int layer);
	//extern	void	photo_display(void);
#endif

#endif // __S1D13781_H

/*** end of s1d13781.h *****************************************/
