/***********************************************************************

	rtc.h
	
	real time clock module

	2013/7/16  S.Suwa http://www.suwa-koubou.jp	
***********************************************************************/

#ifndef _RTC_H
#define	_RTC_H

#define	lock_timer()	IEC0CLR=_IEC0_T1IE_MASK
#define unlock_timer()	IEC0SET=_IEC0_T1IE_MASK
#define	clear_timer()	IFS0CLR=_IFS0_T1IF_MASK

// in rtc.c 
void	rtc_init(void);
void	rtc_set(char *date_time);
void	get_rtcstr(char *buf);
void	get_rtc(char data[]);
DWORD	get_fattime (void);
void	set_fattime(void);
void    delay_ms(int t);

extern	DWORD AplTimer;               // in rtc.c
extern  volatile int one_sec_flg;     // in main.c
extern  void disk_timerproc (void);	  // in diskio.c
extern  void key_scan(void);		  // in key.c

#endif
