/************************************************

	menu.c

************************************************/

#include <string.h>
#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "font.h"
#include "s1d13781.h"
#include "key.h"


typedef unsigned short LOCATE;
extern BYTE vramBuffer[320 * 2 * 16]  __attribute__ ((aligned(sizeof(WORD))));

void lcd_putstr(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str);
void lcd_putstr_wide(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str);

static unsigned char  *opstr[] = {
	" Set Date & Time ",
	" SD Play         ",
	" SD Record       ",
	" Photo Frame     ",
};

typedef enum {
	OP_SET_TIME=0,
	OP_SD_PLAY,
	OP_SD_RECORD,
	OP_PHOTO_FRAME,
	OP_EXIT,
} OPCODE;


/*---------------------------------------------------------------------------------------------
	select operation
---------------------------------------------------------------------------------------------*/

OPCODE	select_operation(void)
{
	KEYCODE	key;
	int    op, n;
	LOCATE x, y;
	WORD   fg, bg;
	
	x = 10;
	y = 6;

	for(op = 0;;){

		for(n = 0; n < sizeof(opstr)/sizeof(opstr[0]);n++){
			fg = cRED;
			bg = (n == op)? cCYAN: cBLACK;
			lcd_putstr(PIP_LAYER, x, y+(n*3), fg, bg, opstr[n]);
		}

		while((key = getkey()) == KEY_NONE){
			if(display_background() == 0){
				return OP_EXIT;
			}
		}

		switch(key){
		case KEY_SET:
			return (OPCODE)op;

		case KEY_UP:
			if(--op < 0) op = (int)OP_PHOTO_FRAME;
			break;

		case KEY_DOWN:
			if(++op > (int)OP_PHOTO_FRAME) op = 0;
			break;
		}
	}

}



void test_show_menu(void)
{
	lcd_putstr(MAIN_LAYER, 10, 2, wRGB565[cRED], wRGB565[cBLACK], opstr[0]);
	lcd_putstr(MAIN_LAYER, 10, 3, wRGB565[cBLUE], wRGB565[cBLACK], opstr[1]);
	lcd_putstr(MAIN_LAYER, 10, 4, wRGB565[cYELLOW], wRGB565[cMAGENTA], opstr[2]);

	lcd_putstr_wide(MAIN_LAYER, 10, 6, wRGB565[cRED], wRGB565[cCYAN], opstr[0]);
	lcd_putstr_wide(MAIN_LAYER, 10, 8, wRGB565[cBLUE], wRGB565[cYELLOW], opstr[1]);
	lcd_putstr_wide(MAIN_LAYER, 10,10, wRGB565[cGREEN], wRGB565[cMAGENTA], opstr[2]);
}

void show_menu(int layer)
{
	lcd_putstr_wide(layer, 10, 8, wRGB565[cRED], wRGB565[cBLACK], opstr[0]);
	lcd_putstr_wide(layer, 10,11, wRGB565[cRED], wRGB565[cBLACK], opstr[1]);
	lcd_putstr_wide(layer, 10,14, wRGB565[cRED], wRGB565[cCYAN], opstr[2]);
}

/*---------------------------------------------------------------------------------------------
	void lcd_putstr(layer, x, y, fore_color, back_color, *str)
---------------------------------------------------------------------------------------------*/

void lcd_putstr(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str)
{
	WORD	*bf;
	int		sx, sy, len, p, mask, code;
	DWORD	addr;


	for(sy = 0; sy < 8; sy++){
		bf = (WORD *)(vramBuffer + (sy * 640));
		mask = (1 << sy);
		for(p = 0; str[p]; p++){
			code = str[p] - ' ';
			for(sx = 0; sx < 6; sx++){
				*bf++ = (font[code][sx] & mask) ? fore_color: back_color;
			}
		}
	}

	len = strlen(str);
	addr = (layer == MAIN_LAYER)? MAIN_VRAM_ADR: PIP_VRAM_ADR;
	addr += (y * 8 * 640 + x * 6 * 2 +4); // 4 is fixed left offset. 
	for(sy = 0; sy < 8; sy++){
		write_byte_block(addr + sy * 640, vramBuffer + sy * 640, len * 6 * 2);
	}
}

/*---------------------------------------------------------------------------------------------
	void lcd_putstr_wide(layer, x, y, fore_color, back_color, *str)
---------------------------------------------------------------------------------------------*/

void lcd_putstr_wide(BYTE layer, LOCATE x, LOCATE y, WORD fore_color, WORD back_color, BYTE *str)
{
	WORD	*bf;
	int		sx, sy, len, p, mask, code;
	DWORD	addr;


	for(sy = 0; sy < 8; sy++){
		bf = (WORD *)(vramBuffer + (sy * 2 * 640));
		mask = (1 << sy);
		for(p = 0; str[p]; p++){
			code = str[p] - ' ';
			for(sx = 0; sx < 6; sx++){
				*bf = *(bf +1) = *(bf + 320) = *(bf + 321) = (font[code][sx] & mask) ? fore_color: back_color;
				bf+= 2;
			}
		}
	}

	len = strlen(str);
	addr = (layer == MAIN_LAYER)? MAIN_VRAM_ADR: PIP_VRAM_ADR;
	addr += (y * 8 * 640 + x * 6 * 2 +4); // 4 is fixed left offset. 
	for(sy = 0; sy < (8 * 2); sy++){
		write_byte_block(addr + sy * 640, vramBuffer + sy * 640, len * 6 * 2 * 2);
	}
}


/*** end of menu.c ****************************************************************************/
