/****************************************************************************

	key.c

	2013/7/16  S.Suwa http://www.suwa-koubou.jp	
****************************************************************************/

#include "HardwareProfile.h"
#include "GenericTypeDefs.h"
#include "key.h"


#define	keyPort(n)	(((PORTD >> (9+n)) & 1)? 0: 1)
#define	CHATTERING_TIMES	50	// 50times * 1msec

static KEYCODE	ktbl[3] = { KEY_SET, KEY_UP, KEY_DOWN, };
static BYTE	rawKey[3], cntKey[3], prevKey[3];	// SET, UP, DOWN

/* ----------------------------------------------------------------------
	key low level scan
	This function must be called by timer interrupt in period of 1ms
---------------------------------------------------------------------- */

void key_scan(void)
{
	int	 n;
	BYTE key;

	for(n = 0; n < 3; n++){
		key = keyPort(n);
		if(rawKey[n] != key){
			if(cntKey[n]){
				if(--cntKey[n] == 0){
					rawKey[n] = key;
				}
			}else{
				cntKey[n] = CHATTERING_TIMES;
			}
		}else{
			// counter reset;
			cntKey[n] = 0;
		}
	}

}


/* ----------------------------------------------------------------------
	getkey() 
	 read rawKey

	key change detect, only just off to on rise edge detect
---------------------------------------------------------------------- */
		
KEYCODE	getkey(void)
{
	KEYCODE	key;
	int	n;

	key = KEY_NONE;
	for(n = 0; n < 3; n++){
		if(prevKey[n] != rawKey[n]){
			if(rawKey[n]){
				key |= ktbl[n];
			}
			prevKey[n] = rawKey[n];
		}
	}
	return key;
}
	

/*** end of key.c *******************************************************/
