/******************************************************************
	isr_macro.h

	2013/6/23  S.Suwa http://www.suwa-koubou.jp	
******************************************************************/ 	

    .set noreorder
	.set noat
	.extern _curtsk
	.extern _stckptr

	.equ    OFFSET_SR,      4
	.equ    OFFSET_EPC,     OFFSET_SR    + 4
	.equ    OFFSET_LO,      OFFSET_EPC   + 4
	.equ    OFFSET_HI,      OFFSET_LO    + 4
	.equ    OFFSET_GPR1,    OFFSET_HI    + 4
	.equ    OFFSET_GPR2,    OFFSET_GPR1  + 4
	.equ    OFFSET_GPR3,    OFFSET_GPR2  + 4
	.equ    OFFSET_GPR4,    OFFSET_GPR3  + 4
	.equ    OFFSET_GPR5,    OFFSET_GPR4  + 4
	.equ    OFFSET_GPR6,    OFFSET_GPR5  + 4
	.equ    OFFSET_GPR7,    OFFSET_GPR6  + 4
	.equ    OFFSET_GPR8,    OFFSET_GPR7  + 4
	.equ    OFFSET_GPR9,    OFFSET_GPR8  + 4
	.equ    OFFSET_GPR10,   OFFSET_GPR9  + 4
	.equ    OFFSET_GPR11,   OFFSET_GPR10 + 4
	.equ    OFFSET_GPR12,   OFFSET_GPR11 + 4
	.equ    OFFSET_GPR13,   OFFSET_GPR12 + 4
	.equ    OFFSET_GPR14,   OFFSET_GPR13 + 4
	.equ    OFFSET_GPR15,   OFFSET_GPR14 + 4
	.equ    OFFSET_GPR16,   OFFSET_GPR15 + 4
	.equ    OFFSET_GPR17,   OFFSET_GPR16 + 4
	.equ    OFFSET_GPR18,   OFFSET_GPR17 + 4
	.equ    OFFSET_GPR19,   OFFSET_GPR18 + 4
	.equ    OFFSET_GPR20,   OFFSET_GPR19 + 4
	.equ    OFFSET_GPR21,   OFFSET_GPR20 + 4
	.equ    OFFSET_GPR22,   OFFSET_GPR21 + 4
	.equ    OFFSET_GPR23,   OFFSET_GPR22 + 4
	.equ    OFFSET_GPR24,   OFFSET_GPR23 + 4
	.equ    OFFSET_GPR25,   OFFSET_GPR24 + 4
	.equ    OFFSET_GPR26,   OFFSET_GPR25 + 4
	.equ    OFFSET_GPR27,   OFFSET_GPR26 + 4
	.equ    OFFSET_GPR28,   OFFSET_GPR27 + 4
	.equ    OFFSET_GPR30,   OFFSET_GPR28 + 4
	.equ    OFFSET_GPR31,   OFFSET_GPR30 + 4 
	.equ    CTX_SIZE,       OFFSET_GPR31 + 4

/*** save context ***********************************/
.macro	SAVE_CONTEXT

    /* Adjust the stack pointer */                      
    addi  $29, $29, - CTX_SIZE

    /* Save the General Purpose Registers  */
    sw    $1,  OFFSET_GPR1($29) 
    sw    $2,  OFFSET_GPR2($29)
    sw    $3,  OFFSET_GPR3($29)
    sw    $4,  OFFSET_GPR4($29)
    sw    $5,  OFFSET_GPR5($29)
    sw    $6,  OFFSET_GPR6($29)
    sw    $7,  OFFSET_GPR7($29)
    sw    $8,  OFFSET_GPR8($29)
    sw    $9,  OFFSET_GPR9($29)
    sw    $10, OFFSET_GPR10($29)
    sw    $11, OFFSET_GPR11($29)
    sw    $12, OFFSET_GPR12($29)
    sw    $13, OFFSET_GPR13($29)
    sw    $14, OFFSET_GPR14($29)
    sw    $15, OFFSET_GPR15($29)
    sw    $16, OFFSET_GPR16($29)
    sw    $17, OFFSET_GPR17($29)
    sw    $18, OFFSET_GPR18($29)
    sw    $19, OFFSET_GPR19($29)
    sw    $20, OFFSET_GPR20($29)
    sw    $21, OFFSET_GPR21($29)
    sw    $22, OFFSET_GPR22($29)
    sw    $23, OFFSET_GPR23($29)
    sw    $24, OFFSET_GPR24($29)
    sw    $25, OFFSET_GPR25($29)
    sw    $26, OFFSET_GPR26($29)
    sw    $27, OFFSET_GPR27($29)
    sw    $28, OFFSET_GPR28($29)
    sw    $30, OFFSET_GPR30($29)
    sw    $31, OFFSET_GPR31($29)

    /* Save the contents of the LO and HI registers  */
    mflo  $8
    mfhi  $9
    sw    $8,  OFFSET_LO($29)
    sw    $9,  OFFSET_HI($29)

	/* Save EPC resister */
    mfc0  $8,  $14, 0 
    sw    $8,  OFFSET_EPC($29)

	/* Save the Status register */
    mfc0  $8,  $12, 0                          
    sw    $8,  OFFSET_SR($29)

	.endm /* SAVE_CONTEXT */

/*** switch main task **********************************/
/* Task ID of main task is 0. */
.macro  SWITCH_MAIN_TASK
	/* saved stack pointer of current task */
	/* _stckptr[_curtsk] = $29(sp) */
	la    t0,  _curtsk
    la    t1,  _stckptr
    lw    v0,  (t0)
    sll   v0,  v0,2
    addu  v0,  v0,t1
    sw    $29, (v0)
	/* _curtsk = 0;(main task) */
	sw    zero, (t0)
	/* $29(sp) = _stckptr[0] */
	lw    $29,  (t1)

	.endm /* SWITCH_MAIN_TASK */

/*** restore context ***********************************/
.macro	RESTORE_CONTEXT
    /* Restore the Status register  */
    lw    $8,  OFFSET_SR($29)
    mtc0  $8,  $12, 0 

	/* Restore the EPC */
    lw    $8,  OFFSET_EPC($29)     
    mtc0  $8,  $14, 0

    /* Restore the contents of the LO and HI registers */
    lw    $8,  OFFSET_LO($29)
    lw    $9,  OFFSET_HI($29)
    mtlo  $8
    mthi  $9

    /* Restore the General Purpose Registers  */
    lw    $31, OFFSET_GPR31($29)
    lw    $30, OFFSET_GPR30($29)
    lw    $28, OFFSET_GPR28($29)
    lw    $27, OFFSET_GPR27($29)
    lw    $26, OFFSET_GPR26($29)
    lw    $25, OFFSET_GPR25($29)
    lw    $24, OFFSET_GPR24($29)
    lw    $23, OFFSET_GPR23($29)
    lw    $22, OFFSET_GPR22($29)
    lw    $21, OFFSET_GPR21($29)
    lw    $20, OFFSET_GPR20($29)
    lw    $19, OFFSET_GPR19($29)
    lw    $18, OFFSET_GPR18($29)
    lw    $17, OFFSET_GPR17($29)
    lw    $16, OFFSET_GPR16($29)
    lw    $15, OFFSET_GPR15($29)
    lw    $14, OFFSET_GPR14($29)
    lw    $13, OFFSET_GPR13($29)
    lw    $12, OFFSET_GPR12($29)
    lw    $11, OFFSET_GPR11($29)
    lw    $10, OFFSET_GPR10($29)
    lw    $9,  OFFSET_GPR9($29)
    lw    $8,  OFFSET_GPR8($29)
    lw    $7,  OFFSET_GPR7($29)
    lw    $6,  OFFSET_GPR6($29)
    lw    $5,  OFFSET_GPR5($29)
    lw    $4,  OFFSET_GPR4($29)
    lw    $3,  OFFSET_GPR3($29)
    lw    $2,  OFFSET_GPR2($29)
    lw    $1,  OFFSET_GPR1($29)

    /* Adjust the stack pointer */   
    addi  $29, $29, CTX_SIZE

	/* Resume execution in new task */
    eret                  

	.endm /* RESTORE_CONTEXT */

/*** end of isr_macro.h ******************************************/
