/****************************************************************

	dump_descriptor.c

	2013/7/16  S.Suwa http://www.suwa-koubou.jp	
****************************************************************/

#define	DEBUG_MODE
#ifdef DEBUG_MODE

#include "uart2.h"

#define	putstr(x)	UART2PrintString(x)
#define	puthex(x)	UART2PutHex(x)
#define	putch(x)	UART2PutChar(x)

void	putcrlf(void)
{
	putstr("\r\n");
}

void	putdec(unsigned int d)
{
	int div, first, rd;

	rd = 10000;
	first = 1;

	do {
		div = d/rd;
		d = d % rd;
		if(div){
			putch(div+'0');
			first = 0;
		}else if(!first){
			putch('0');
		}
		rd /= 10;
	}while(rd != 1);
	putch(d+'0');
}


const char *bmStr[3][8]={
  {
	"Brightness", // D0
	"Contrast",   // D1
	"Hue",        // D2 
	"Saturation", // D3
	"Sharpness",  // D4
	"Gamma",      // D5
	"White Balance Temperature", // D6
	"White Balance Component",   // D7
  },
  {
	"Backlight Compensation", // D0
	"Gain",                   // D1  
	"Power Line Frequency",   // D2
	"Hue.Auto",               // D3
	"White Balance Temperature.Auto", // D4
	"White Balance Component.Auto",  // D5
	"Digital Multiplier",         // D6
	"Digital Multiplier Limit",  // D7
  },
  {
	"Analog Video Statndard",  // D0
	"Analog Video Lock Status", // D1
	"Reserved",
	"Reserved",
	"Reserved",
	"Reserved",
	"Reserved",
	"Reserved",
  },
};


static void	dump_process_bmControls(char data, int map)
{
	int	i;

	for(i = 0; i < 8; i++){
		putstr("\t\tD"); putdec(i + map*8);
		if(data & (1 << i))	putstr("= yes ");
		else putstr("= no ");
		putstr((char *)bmStr[map][i]); putcrlf();
	}
}



void	dump_descriptor(unsigned char *p, int len)
{
	int	i, j, n, interface_subclass,interface_class ;

	return;

	n = 0;
	while(n < len){
		switch(p[n +1]){
		case 0x01:
			putstr("\t*** Device Descriptor\r\n");
			putstr("\tbLength=0x");         puthex(p[n+0]); putcrlf();
			putstr("\tbDescriptor=0x");     puthex(p[n+1]); putcrlf();
			putstr("\tbcdUSB=0x");          puthex(p[n+3]); puthex(p[n+2]); putcrlf();
			putstr("\tbDeviceClass=0x");    puthex(p[n+4]); putcrlf();
			putstr("\tbDeviceSubClass=0x"); puthex(p[n+5]); putcrlf();
			putstr("\tbDeviceProtocol=0x"); puthex(p[n+6]); putcrlf();
			putstr("\tbMaxPacketSize0=0x"); puthex(p[n+7]); putcrlf();
			putstr("\tidVendor=0x");        puthex(p[n+9]); puthex(p[n+8]); putcrlf();
			putstr("\tidProduct=0x");       puthex(p[n+11]);puthex(p[n+10]); putcrlf();
			putstr("\tbcdDevice=0x");       puthex(p[n+13]);puthex(p[n+12]); putcrlf();
			putstr("\tiManufacture=0x");    puthex(p[n+14]);putcrlf();
			putstr("\tiProduct=0x");        puthex(p[n+15]);putcrlf();
			putstr("\tiSerialNumber=0x");   puthex(p[n+16]);putcrlf();
			putstr("\tbNumConfigurations=0x"); puthex(p[n+17]); putcrlf();
			n += p[n];
			break;

		case 0x02: // configuration descriptor
			putstr("\t*** ConfigurationDescriptor\r\n");
			putstr("\tbLength=");               putdec(p[n+0]); putcrlf();
			putstr("\tbDescriptor=0x");         puthex(p[n+1]); putcrlf();
			putstr("\twTotalLength=");          putdec((unsigned int)(p[n+3])*256 + p[n+2]); putcrlf();
			putstr("\tbNumInterfaces=0x");      puthex(p[n+4]); putcrlf();
			putstr("\tbConfigurationValue=0x"); puthex(p[n+5]); putcrlf();
			putstr("\tiConfiguration=0x");      puthex(p[n+6]); putcrlf();
			putstr("\tbmAttributes=0x");        puthex(p[n+7]); putcrlf();
			putstr("\tbMaxPower=0x");           puthex(p[n+8]); putcrlf();
			n += p[n];
			break;

		case 0x04: // interface descriptor
			putstr("\t*** InterfaceDescriptor\r\n");
			putstr("\tbLength=");              putdec(p[n+0]); putcrlf();
			putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
			putstr("\tbInterfaceNumber=0x");   puthex(p[n+2]); putcrlf();
			putstr("\tbAlternateSetting=0x");  puthex(p[n+3]); putcrlf();
			putstr("\tbNumEndPoints=0x");      puthex(p[n+4]); putcrlf();
			putstr("\tbInterfaceClass=0x");    puthex(p[n+5]);
			if(p[n+5] == 0x0e){
				putstr("\tVideo Class\r\n");
			}else if(p[n+5] == 0x01){
				putstr("\tAudio Class\r\n");
			}else{
				putcrlf();
			}
			putstr("\tbInterfaceSubClass=0x"); puthex(p[n+6]); putcrlf();
			putstr("\tbInterfaceProtocol=0x"); puthex(p[n+7]); putcrlf();
			putstr("\tiInterface=0x");         puthex(p[n+8]); putcrlf();
			interface_subclass = p[n+6];
			interface_class = p[n+5];
			n += p[n];
			break;

		case 0x05:	// endpoint descriptor
			putstr("\t*** EndpointDescriptor\r\n");
			putstr("\tbLength=");              putdec(p[n+0]); putcrlf();
			putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
			putstr("\tbEndPointAddress=0x");   puthex(p[n+2]); putcrlf();
			putstr("\tbmAttributes=0x");       puthex(p[n+3]); putcrlf();
			putstr("\twMaxPacketSize=");       putdec((unsigned int)(p[n+5]) * 256 + p[n+4]); putcrlf();
			putstr("\tbInterval=0x");          puthex(p[n+6]); putcrlf();
			n += p[n];
			break;

		case 0x03:	// string descriptor
			putstr("\t*** StringDescriptor\r\n"); n += p[n];
			break;
		case 0x06:	// device qualifier
			putstr("\t*** DeviceQualifierDescriptor\r\n"); n += p[n];
			break;
		case 0x07:	// other speed configuration
			putstr("\t*** OtherSpeedConfigurationDescriptor\r\n"); n += p[n];
			break;

		case 0x0b: // INTERFACE ASSOCIATION descriptor
			putstr("\t*** Interface Association Descriptor\r\n");
			putstr("\tbLength=");              putdec(p[n+0]); putcrlf();
			putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
			putstr("\tbFirstInterface=0x");    puthex(p[n+2]); putcrlf();
			putstr("\tbInterfaceCount=0x");    puthex(p[n+3]); putcrlf();
			putstr("\tbFunctionClass=0x");     puthex(p[n+4]); putcrlf();
			putstr("\tbFunctionSubClass=0x");  puthex(p[n+5]); putcrlf();
			putstr("\tbFunctionProtocol=0x");  puthex(p[n+6]); putcrlf();
			putstr("\tiFunction=0x");          puthex(p[n+7]); putcrlf();
			n += p[n];
			break;

		case 0x24:	// CS_INTERFACE
			if(interface_class == 0x0e && interface_subclass == 0x01){ // Video Control
				putstr("\t*** Video Control Interface Descriptor\r\n");
				putstr("\tbLength=");              putdec(p[n+0]); putcrlf();
				putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
				putstr("\tbDescriptorSubType=0x"); puthex(p[n+2]);
				switch(p[n+2]){
				case 0x01:	// VC_HEADER
					putstr(" [VC_HEADER]\r\n");			
					putstr("\tbcdUVC=0x");           puthex(p[n+4]); puthex(p[n+3]); putcrlf();
					putstr("\twTotalLength=");       putdec((unsigned int)(p[n+6]) * 256 + p[n+5]); putcrlf();
					putstr("\tdwClockFrequency=0x"); puthex(p[n+10]);puthex(p[n+9]); puthex(p[n+8]); puthex(p[n+7]); putcrlf();
					putstr("\tbInCollection=0x");    puthex(p[n+11]);putcrlf();
					for(i = 0; i < p[n+11]; i++){
						putstr("\tbaInterfaceNr=0x"); puthex(p[n+12+i]); putcrlf();
					}
					break;

				case 0x02:	// VC_INPUT_TERMINAL
					putstr(" [VC_INPUT_TERMINAL]\r\n");			
					putstr("\tbTerminalID=0x");     puthex(p[n+3]); putcrlf();
					putstr("\twTerminalType=0x");   puthex(p[n+5]); puthex(p[n+4]); putcrlf();
					putstr("\tbAcssocTerminal=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tiTerminal=0x");       puthex(p[n+7]); putcrlf();
					if(p[n+4] != 0x01 || p[n+5] != 0x02){   // !CAMERA
						for(i = 8; i < p[n]; i++){
							putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
						}
						break;
					}
					// CAMERA
					putstr("\twObjectiveFocalLengthMin=0x"); puthex(p[n+9]); puthex(p[n+8]); putcrlf();
					putstr("\twObjectiveFocalLengthMax=0x"); puthex(p[n+11]); puthex(p[n+10]); putcrlf();
					putstr("\twOcularFocalLength=0x");       puthex(p[n+13]); puthex(p[n+12]); putcrlf();
					putstr("\tbControlSize=0x");             puthex(p[n+14]); putcrlf();
					putstr("\tbmControls=0x"); for(i = p[n+14]; i > 0; i--) puthex(p[n+14+i]); putcrlf();
					break;

				case 0x03:	// VC_OUTPUT_TERMINAL
					putstr(" [VC_OUTPUT_TERMINAL]\r\n");			
					putstr("\tbTerminalID=0x");     puthex(p[n+3]); putcrlf();
					putstr("\twTerminalType=0x");   puthex(p[n+5]); puthex(p[n+4]); putcrlf();
					putstr("\tbAcssocTerminal=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tbSourceID=0x");       puthex(p[n+7]); putcrlf();
					putstr("\tiTerminal=0x");       puthex(p[n+8]); putcrlf();
					for(i = 9; i < p[n]; i++){
						putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
					}
					break;

				case 0x04:	// VC_SELECTOR_UNIT
					putstr(" [VC_SELECTOR_UNIT]\r\n");
					putstr("\tbUnitID=0x");    puthex(p[n+3]); putcrlf();
					putstr("\tbNrInPins=0x");  puthex(p[n+4]); putcrlf();
					for(i = 0; i < p[n+4]; i++){
						putstr("\tbaSourceID=0x"); puthex(p[n+5+i]); putcrlf();
					}
					putstr("\tiSelector=0x");  puthex(p[n+5+p[n+4]]); putcrlf();
					break;

				case 0x05:	// VC_PROCESSING_UNIT
					putstr(" [VC_PROCESSING_UNIT]\r\n");			
					putstr("\tbUnitID=0x");       puthex(p[n+3]); putcrlf();
					putstr("\tbSourceID=0x");     puthex(p[n+4]); putcrlf();
					putstr("\twMaxMuliplier=0x"); puthex(p[n+6]); puthex(p[n+5]); putcrlf();
					putstr("\tbControlSize=0x");  puthex(p[n+7]); putcrlf();
					putstr("\tbmControls=0x"); for(i = p[n+7]; i > 0; i--) puthex(p[n+7+i]); putcrlf();
					putstr("\tiProcessing=0x");   puthex(p[n+8+p[n+7]]); putcrlf();
					if(p[n+7] >= 3) {
						putstr("\tbmVideoStandards=0x"); puthex(p[n+9+p[n+7]]); putcrlf();
					}
					for(i = 0; i < p[n+7]; i++){
						dump_process_bmControls(p[n+8+i],i);
					}
					break;

				case 0x06:	// VC_EXTENSION_UNIT
					putstr(" [VC_EXTENSION_UNIT]\r\n");
					putstr("\tbUnitID=0x");      puthex(p[n+3]); putcrlf();
					putstr("\tguidExtensionCode=0x"); for(i = 0; i < 16; i++); puthex(p[n+4+i]); putcrlf();
					putstr("\tbNumControls=0x"); puthex(p[n+20]); putcrlf();
					putstr("\tbNrInPins=0x");    puthex(p[n+21]); putcrlf();
					for(i = 0; i < p[n+21]; i++){
						putstr("\tbaSourceID=0x"); puthex(p[n+22+i]); putcrlf(); 
					}
					putstr("\tbControlSize=0x"); puthex(p[n+22+p[n+21]]); putcrlf();
					putstr("\tbmControls=0x"); for(i =p[n+22+p[n+21]] ; i > 0; i--) puthex(p[n+22+p[n+21]+i]); putcrlf();
					putstr("\tiExtension=0x");   puthex(p[n+23+p[n+21]+p[n+22+p[n+21]]]); putcrlf();
					break;

				default:
					putstr(" [VC_UNDEFINED]\r\n");
					for(i = 3; i < p[n];i++){
						putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
					}
					break;
				}

			}else if(interface_class == 0x0e && interface_subclass == 0x02){ // Video Streaming

				putstr("\t*** Video Streaming Interface Descriptor\r\n");
				putstr("\tbLength=0x");            puthex(p[n+0]); putcrlf();
				putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
				putstr("\tbDescriptorSubType=0x"); puthex(p[n+2]);

				switch(p[n+2]){

				case 0x01:	// VS_INPUT_HEADER
					putstr(" [VS_INPUT_HEADER]\r\n");			
					putstr("\tbNumFormats=0x");      puthex(p[n+3]); putcrlf();
					putstr("\twTotalLength=0x");     puthex(p[n+5]); puthex(p[n+4]); putcrlf();
					putstr("\tbEndpointAddress=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tbmInfo=0x");           puthex(p[n+7]); putcrlf();
					putstr("\tbTerminalLink=0x");    puthex(p[n+8]); putcrlf();
					putstr("\tbStillCaptureMethod=0x"); puthex(p[n+9]); putcrlf();
					putstr("\tbTriggerSupport=0x");  puthex(p[n+10]); putcrlf();
					putstr("\tbTriggerUsage=0x");    puthex(p[n+11]); putcrlf();
					putstr("\tbControlSize=0x");     puthex(p[n+12]); putcrlf();
					for(i = 0; i < p[n+3]; i++){
						putstr("\tbmaControls=0x"); for(j = p[n+12]; j > 0; j--) puthex(p[n+12+j + p[n+3] * p[n+12] ]); putcrlf();
					}
					break;

				case 0x02:	// VS_OUTPUT_HEADER
					putstr(" [VS_OUTPUT_HEADER]\r\n");			
					putstr("\tbNumFormats=0x");      puthex(p[n+3]); putcrlf();
					putstr("\twTotalLength=0x");     puthex(p[n+5]); puthex(p[n+4]); putcrlf();
					putstr("\tbEndpointAddress=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tbTerminalLink=0x");    puthex(p[n+7]); putcrlf();
					putstr("\tbControlSize=0x");     puthex(p[n+8]); putcrlf();
					for(i = 0; i < p[n+3]; i++){
						putstr("\tbmaControls=0x"); for(j = p[n+8]; j > 0; j--) puthex(p[n+8+j + p[n+3] * p[n+8] ]); putcrlf();
					}
					break;

				case 0x03:	// VS_STILL_IMAGE_FRAME
					putstr(" [VS_STILL_IMAGE_FRAME]\r\n");
					putstr("\tbEndpointAddress=0x");      puthex(p[n+3]); putcrlf();
					putstr("\tbNumImageSizePatterns=0x"); puthex(p[n+4]); putcrlf();
					for(i = 0; i < p[n+4]; i++){
						putstr("\twWidth=");  putdec((unsigned int)(p[n+6+i*4]) * 256 + p[n+5+i*4]); putcrlf();
						putstr("\twHeight="); putdec((unsigned int)(p[n+8+i*4]) * 256 + p[n+7+i*4]); putcrlf();
					}
					putstr("\tbNumCompressionPattern=0x");  puthex(p[n+9+p[n+4]*4-4]); putcrlf();
					for(i = 0; i < p[n+9+p[n+4]*4-4]; i++){
						putstr("\tbCompression=0x");  puthex(p[n+10+p[n+4]*4-4+i]); putcrlf();
					}
					break;
				
				case 0x04:	// VS_FORMAT_UNCOMPRESSED
					putstr(" [VS_FORMAT_UNCOMPRESSED]\r\n");
					putstr("\tbFormatIndex=0x");       puthex(p[n+3]); putcrlf();
					putstr("\tbNumFrameDescriptor=0x");puthex(p[n+4]); putcrlf();
					putstr("\tguidFormat=0x"); for(i = 0; i < 16; i++) puthex(p[n+5+i]); putcrlf();
					putstr("\tbBitsPerPixel=0x");      puthex(p[n+21]); putcrlf();
					putstr("\tbDefaultFrameIndex=0x"); puthex(p[n+22]); putcrlf();
					putstr("\tbAspectRatioX=0x");      puthex(p[n+23]); putcrlf();
					putstr("\tbAspectRatioY=0x");      puthex(p[n+24]); putcrlf();
					putstr("\tbmInterlaceFlags=0x");   puthex(p[n+25]); putcrlf();
					putstr("\tbCopyProtect=0x");       puthex(p[n+26]); putcrlf();
					break;

				case 0x05:  // VS_FRAME_UNCOMPRESSD
					putstr(" [VS_FRAME_UNCOMPRESSED]\r\n");
					putstr("\tbFrameIndex=0x");        puthex(p[n+3]); putcrlf();
					putstr("\tbmCapabilities=0x");     puthex(p[n+4]); putcrlf();
					putstr("\twWidth="); putdec((int)(p[n+6]) * 256 + p[n+5]); putcrlf();
					putstr("\twHeight=");putdec((int)(p[n+8]) * 256 + p[n+7]); putcrlf();
					putstr("\tdwMinBitRate=0x"); puthex(p[n+12]);puthex(p[n+11]);puthex(p[n+10]);puthex(p[n+9]); putcrlf();
					putstr("\tdwMaxBitRate=0x"); puthex(p[n+16]);puthex(p[n+15]);puthex(p[n+14]);puthex(p[n+13]); putcrlf();
					putstr("\tdwMaxVideoFrameBufferSize=0x"); puthex(p[n+20]);puthex(p[n+19]);puthex(p[n+18]);puthex(p[n+17]); putcrlf();
					putstr("\tdwDefaultFrameInterval=0x"); puthex(p[n+24]);puthex(p[n+23]);puthex(p[n+22]);puthex(p[n+21]); putcrlf();
					putstr("\tbFrameIntervalType=0x");     puthex(p[n+25]); putcrlf();
					for(i = 0; i < p[n+25]; i++){
						putstr("\tdwFrameInterval=0x");puthex(p[n+29+i*4]);puthex(p[n+28+i*4]);puthex(p[n+27+i*4]);puthex(p[n+26+i*4]); putcrlf();
					}
					break;			

				case 0x06:	// VS_FORMAT_MJPEG
					putstr(" [VS_FORMAT_MJPEG]\r\n");
					putstr("\tbFormatIndex=0x");       puthex(p[n+3]); putcrlf();
					putstr("\tbNumFrameDescriptors=0x");puthex(p[n+4]); putcrlf();
					putstr("\tbmFlags=0x");            puthex(p[n+5]); putcrlf();
					putstr("\tbDefaultFrameIndex=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tbAspectRatioX=0x");      puthex(p[n+7]); putcrlf();
					putstr("\tbAspectRatioY=0x");      puthex(p[n+8]); putcrlf();
					putstr("\tbmInterlaceFlags=0x");   puthex(p[n+9]); putcrlf();
					putstr("\tbCopyProtect=0x");       puthex(p[n+10]); putcrlf();
					break;

				case 0x07:  // VS_FRAME_MJPEG
					putstr(" [VS_FRAME_MJPEG]\r\n");
					putstr("\tbFrameIndex=0x");        puthex(p[n+3]); putcrlf();
					putstr("\tbmCapabilities=0x");     puthex(p[n+4]); putcrlf();
					putstr("\twWidth="); putdec((int)(p[n+6]) * 256 + p[n+5]); putcrlf();
					putstr("\twHeight=");putdec((int)(p[n+8]) * 256 + p[n+7]); putcrlf();
					putstr("\tdwMinBitRate=0x"); puthex(p[n+12]);puthex(p[n+11]);puthex(p[n+10]);puthex(p[n+9]); putcrlf();
					putstr("\tdwMaxBitRate=0x"); puthex(p[n+16]);puthex(p[n+15]);puthex(p[n+14]);puthex(p[n+13]); putcrlf();
					putstr("\tdwMaxVideoFrameBufferSize=0x"); puthex(p[n+20]);puthex(p[n+19]);puthex(p[n+18]);puthex(p[n+17]); putcrlf();
					putstr("\tdwDefaultFrameInterval=0x"); puthex(p[n+24]);puthex(p[n+23]);puthex(p[n+22]);puthex(p[n+21]); putcrlf();
					putstr("\tbFrameIntervalType=0x");     puthex(p[n+25]); putcrlf();
					if(p[n+25] == 0){	// Continuous frame interval
						putstr("\tdwMinFrameInterval=0x");puthex(p[n+29]);puthex(p[n+28]);puthex(p[n+27]);puthex(p[n+26]); putcrlf();
						putstr("\tdwMaxFrameInterval=0x");puthex(p[n+33]);puthex(p[n+32]);puthex(p[n+31]);puthex(p[n+30]); putcrlf();
						putstr("\tdwFrameIntervalStep=0x");puthex(p[n+37]);puthex(p[n+36]);puthex(p[n+35]);puthex(p[n+34]); putcrlf();
					}else{	// Discrete frame intervals supported
						for(i = 0; i < p[n+25]; i++){
							putstr("\tdwFrameInterval=0x");puthex(p[n+29+i*4]);puthex(p[n+28+i*4]);puthex(p[n+27+i*4]);puthex(p[n+26+i*4]); putcrlf();
						}
					}
					break;	

				case 0x08:	// Reserved
				case 0x09:	// Reserved
					break;

				case 0x0a:	// VS_FORMAT_MPEG2TS
					putstr(" [VS_FORMAT_MPEG2TS]\r\n");
					putstr("\tbFormatIndex=0x");  puthex(p[n+3]); putcrlf();
					putstr("\tbDataOffset=0x");   puthex(p[n+4]); putcrlf();
					putstr("\tbPacketLength=0x"); puthex(p[n+5]); putcrlf();
					putstr("\tbStrideLength=0x"); puthex(p[n+6]); putcrlf();
					putstr("\tguidFormat=0x"); for(i = 0; i < 16; i++) puthex(p[n+7+i]); putcrlf();
					break;

				case 0x0b:	// Reserved
					break;

				case 0x0c:	// VS_FORMAT_DV
					putstr(" [VS_FORMAT_DV]\r\n");
					putstr("\tbFormatIndex=0x");       puthex(p[n+3]); putcrlf();
					putstr("\tdwMaxVideoFrameBufferSize=0x"); puthex(p[n+7]);puthex(p[n+6]);puthex(p[n+5]);puthex(p[n+4]); putcrlf();
					putstr("\tbFormatType=0x");       puthex(p[n+8]); putcrlf();
					break;


				case 0x0d:	// VS_COLORFORMAT
					putstr(" [VS_COLOR_FORMAT]\r\n");
					putstr("\tbColorPrimaries=0x"); puthex(p[n+3]); putcrlf();
					putstr("\tbTransferCharacteristics=0x"); puthex(p[n+4]); putcrlf();
					putstr("\tbMatrixCoefficients=0x"); puthex(p[n+5]); putcrlf();
					break;

				case 0x0e:	// Reserved
				case 0x0f:	// Reserved
					break;

				case 0x10:	// VS_FORMAT_FRAME_BASED
					putstr(" [VS_FORMAT_FRAME_BASED]\r\n");
					putstr("\tbFormatIndex=0x");    puthex(p[n+3]); putcrlf();
					putstr("\tbNumFrameDescriptors=0x");puthex(p[n+4]); putcrlf();
					putstr("\tguidFormat=0x"); for(i = 0; i < 16; i++) puthex(p[n+5+i]); putcrlf();
					putstr("\tbBitsPerPixel=0x");      puthex(p[n+21]); putcrlf();
					putstr("\tbDefaultFrameIndex=0x"); puthex(p[n+22]); putcrlf();
					putstr("\tbAspectRatioX=0x");      puthex(p[n+23]); putcrlf();
					putstr("\tbAspectRatioY=0x");      puthex(p[n+24]); putcrlf();
					putstr("\tbmInterlaceFlags=0x");   puthex(p[n+25]); putcrlf();
					putstr("\tbCopyProtect=0x");       puthex(p[n+26]); putcrlf();
					putstr("\tbVariableSize=0x");       puthex(p[n+27]); putcrlf();
					break;

				case 0x11:  // VS_FRAME_FRAME_BASED
					putstr(" [VS_FRAME_FRAME_BASED]\r\n");
					putstr("\tbFrameIndex=0x");        puthex(p[n+3]); putcrlf();
					putstr("\tbmCapabilities=0x");     puthex(p[n+4]); putcrlf();
					putstr("\twWidth="); putdec((int)(p[n+6]) * 256 + p[n+5]); putcrlf();
					putstr("\twHeight=");putdec((int)(p[n+8]) * 256 + p[n+7]); putcrlf();
					putstr("\tdwMinBitRate=0x"); puthex(p[n+12]);puthex(p[n+11]);puthex(p[n+10]);puthex(p[n+9]); putcrlf();
					putstr("\tdwMaxBitRate=0x"); puthex(p[n+16]);puthex(p[n+15]);puthex(p[n+14]);puthex(p[n+13]); putcrlf();
					putstr("\tdwDefaultFrameInterval=0x"); puthex(p[n+20]);puthex(p[n+19]);puthex(p[n+18]);puthex(p[n+17]); putcrlf();
					putstr("\tbFrameIntervalType=0x");     puthex(p[n+21]); putcrlf();
					putstr("\tdwBytesPerLine=0x"); puthex(p[n+25]);puthex(p[n+24]);puthex(p[n+23]);puthex(p[n+22]); putcrlf();

					if(p[n+21] == 0){	// Continuous frame interval
						putstr("\tdwMinFrameInterval=0x");puthex(p[n+29]);puthex(p[n+28]);puthex(p[n+27]);puthex(p[n+26]); putcrlf();
						putstr("\tdwMaxFrameInterval=0x");puthex(p[n+33]);puthex(p[n+32]);puthex(p[n+31]);puthex(p[n+30]); putcrlf();
						putstr("\tdwFrameIntervalStep=0x");puthex(p[n+37]);puthex(p[n+36]);puthex(p[n+35]);puthex(p[n+34]); putcrlf();
					}else{	// Discrete frame intervals supported
						for(i = 0; i < p[n+21]; i++){
							putstr("\tdwFrameInterval=0x");puthex(p[n+29+i*4]);puthex(p[n+28+i*4]);puthex(p[n+27+i*4]);puthex(p[n+26+i*4]); putcrlf();
						}
					}
					break;


				case 0x12:	// VS_FORMAT_STREAM_BASED
					putstr(" [VS_FORMAT_STREAM_BASED]\r\n");
					putstr("\tbFormatIndex=0x");    puthex(p[n+3]); putcrlf();
					putstr("\tguidFormat=0x"); for(i = 0; i < 16; i++) puthex(p[n+4+i]); putcrlf();
					putstr("\tdwPacketLength=0x"); puthex(p[n+23]);puthex(p[n+22]);puthex(p[n+21]);puthex(p[n+20]); putcrlf();
					break;

				default:
					putstr(" [VS_UNDEFINED]\r\n");
					for(i = 3; i < p[n];i++){
						putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
					}
					break;
				}

			}else{
				putstr("\t*** Unknown Descriptor\r\n");
				putstr("\tbLength=0x");         puthex(p[n+0]); putcrlf();
				putstr("\tbDescriptorType=0x"); puthex(p[n+1]); putcrlf();
				//for(i = 2; i < p[n];i++){
				//	putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
				//}
			}

			n += p[n];
			break;

		case 0x25:	// Class Specific ENDPOINT
			putstr("\t*** CS EndpointDescriptor\r\n");
			putstr("\tbLength=0x");            puthex(p[n+0]); putcrlf();
			putstr("\tbDescriptorType=0x");    puthex(p[n+1]); putcrlf();
			putstr("\tbDescriptorSubType=0x"); puthex(p[n+2]); putcrlf();
			putstr("\twMaxTransferSize=0x");   puthex(p[n+4]); puthex(p[n+3]); putcrlf();
			n += p[n];
			break;


		default:
			putstr("\t*** Unknown Descriptor\r\n");
			putstr("\tbLength=0x");         puthex(p[n+0]); putcrlf();
			putstr("\tbDescriptorType=0x"); puthex(p[n+1]); putcrlf();
			//for(i = 2; i < p[n];i++){
			//	putstr("\t ..... =0x"); puthex(p[n+i]); putcrlf();
			//}
			n+= p[n];
			break;
		}
	}// while()
}

/*** end of dump_descriptor.c ********************************************/

#endif
