#if 0 // don't compile

/******************************************************************************

	image.c


******************************************************************************/

#include "GenericTypedef.h"
#include "usb_host_uvc.h"
#include "s1d13781.h"
#include "tjpgd.h"

// work parameter 
#define	WRKFRAMES       2
#define	WRKLINES        16

// capture image buffer size
#define	FRMBFSZ		( QQVGA_SIZE * sizeof(WORD) * WRKFRAMES )	 // QQVGA, RGB565, 2frames 
#define	VRAMBFSZ	( QVGA_WIDTH * sizeof(WORD) * WRKLINES ) // QVGA, RGB565, 16lines
#define	HEADER_LEN		12	// length of payload header

// frame image data receiving buffer
static BYTE  frameBuffer[FRMBFSZ]  __attribute__ ((aligned(sizeof(WORD))));
static BYTE *frame_wp;		// receive data write pointer
static BYTE *frame_sp;		// frame start pointer
static int	 frame_skip;	// frame skip writing flag
static DWORD frame_size;	// frame data count 
static DWORD frame_bytes;	// frameBuffer data count
//static WORD skip_frames;	// counter of skip frames 

// information queue of received frame 
#define	QUEUE_SIZE    4
#define QUEUE_MASK    3

static
struct {
    volatile WORD	frame_valid;
    volatile BYTE	*frame_sp;
    volatile DWORD	frame_size;
} frameQueue[QUEUE_SIZE];

static int	queuePushIndex, queuePopIndex;

// Call back function pointer.
void	(*ISOC_READ_func)(BYTE *data, DWORD size);

// work buffer for making LCD display data 
BYTE   vramBuffer[VRAMBFSZ]  __attribute__ ((aligned(sizeof(WORD))));

static BYTE	*frame_bp;	// point to frameBuffer
static BYTE	*vram_bp;	// point to vramBuffer
static DWORD vram_addr;	// LCD vram address
static BYTE	 vram_sw;	// LCD layer switch, Main or Pip

// tjpgd work buffer
static JDEC	  jdec;
static BYTE   tjpgd_pool[3000];

#define STAT_STOP	0
#define STAT_START	1
#define	STAT_PAUSE	2

static int yuyv_stat, mjpg_stat;

// *************************************************************************
// *************************************************************************
// Section:  display image to LCD 
// *************************************************************************
// *************************************************************************

/*========================================================================
	display title picture (jpeg format) 
========================================================================*/

#include "title.h"	// title picture image data

void	title_picture_on(void)
{
	// write to MAIN
	vram_addr = MAIN_VRAM_ADR;
	vram_sw = MAIN_LAYER;

	frame_bp = (BYTE *)title_picture;
	if(jd_prepare(&jdec, image_in_func, tjpgd_pool, sizeof(tjpgd_pool), NULL) == JDR_OK){
		jd_decomp(&jdec, lcd_out_func, 0);
	}
}


/*========================================================================
	display QQVGA image data (yuyv format)  
========================================================================*/
//
// start display
//
BYTE yuyv_display_start(void)
{
	int	maxformat, n;

	switch(yuyv_stat){
	case STAT_STOP:
		// support YUYV format?
		maxformat = USBHostUVCGetFormatCount();
		for(n = 0; n < maxformat; n++){
			if(USBHostUVCGetFormat(n) == FMT_YUY2){
				break;
			}
		}
		if(n >= maxformat) return UVC_UNSUPPORTED_FORMAT;

		// support QQVGA ?
		if(USBHostUVCSetFrame(n, QQVGA_WIDTH, QQVGA_HEIGHT) == UVC_UNSUPPORTED_RESOLUTION){
			return UVC_UNSUPPORTED_RESOLUTION;
		}

		// reset frame buffer pointer
		frame_wp = frame_sp = frameBuffer;
		frame_bytes = frame_size = 0;
		// skip_frames = 0;
		frame_skip = 1;
		queuePushIndex = queuePopIndex = 0;
		for(n = 0; n < QUEUE_SIZE; n++) frameQueue[n].frame_valid = 0;

		// Isochronous read, set call back function.
		ISOC_READ_func = receive_frame_data;

		// capture start
		if(USBHostUVCStartFrameCapturing() == UVC_FAIL){
			ISOC_READ_func = NULL;
			return UVC_FAIL;
		}
		yuyv_stat = STAT_START;
		return UVC_SUCCES;

	case STAT_START:
		return UVC_SUCCESS;

	case STAT_PAUSE:
		yuyv_stat = STAT_START;
		return UVC_SUCCESS;

	default:
		return UVC_INVALID;
	}
}

//
// pause display
//
BYTE yuyv_display_pause(void)
{
	if(yuyv_stat == STAT_START) yuyv_stat = STAT_PAUSE;
	return UVC_SUCCESS;
}

//
// stop display
//
BYTE yuyv_display_stop(void)
{
	switch(yuyv_stat){
	case STAT_STOP:
		return UVC_SUCCESS;

	case STAT_PAUSE:
	case STAT_START:
		// Stop Frame Capture
		USBHostUVCStopFrameCapturing();
		// disable call back
		ISOC_READ_func = NULL;

		yuyv_stat = STAT_STOP;
		return UVC_SUCCESS;
	}
}

//
// one frame display
//
void yuyv_display(BYTE layer)
{
	if(yuyv_stat != STAT_START) return;

	// set LCD address
	vram_addr = (layer == MAIN_LAYER ? MAIN_VRAM_ADR: PIP_VRAM_ADR);

	// wait for received one frame 
	while(frameQueue[queuePopIndex].frame_valid == 0);

	// display one frame
	qqvga_display((BYTE *)frameQueue[queuePopIndex].frame_sp);

	// update bytes in frameBuffer
	IEC1CLR = 0x02000000;	// bit 25 USB
	frame_bytes -= frameQueue[queuePopIndex].frame_size;
	IEC1SET = 0x02000000;	// bit 25 USB
	frameQueue[queuePopIndex].frame_valid = 0;
	queuePopIndex++;
	queuePopIndex &= QUEUE_MASK;
}


/*-------------------------------------------------------------------
	one frame display
	convert YUYV to RGB565, scale up from QQVGA to QVGA
-------------------------------------------------------------------*/

void qqvga_display(BYTE *frame)
{
	WORD *dst, *src, x, y;

	// convert YCrCb --> RGB565
	yuv2rgb_color(frame, frame, 160 * 120 * 2);
	src = (WORD *)frame;
	// scaling up from QQVGA to QVGA 
	for(y = 0; y < 119; y++){
		// odd line
		dst = (WORD *)vramBuffer;
		for(x = 0; x < 159; x++){
			dst[0] = src[0];
			dst[1] = avr_rgb(src[0], src[1]); 
			dst += 2;
			src++;
		}
		dst[0] = src[0];
		dst[1] = 0;	     // right edge to BLACK
		write_byte_block(vram_addr, vramBuffer, 320 * 2); 
		vram_addr += (320 * 2);

		// next even line
		src -= 159;
		dst = (WORD *)vramBuffer;
		for(x = 0; x < 159; x++){
			dst[0] = avr_rgb(src[0], src[0 + 160]);
			dst[1] = avr_rgb( avr_rgb(src[0], src[1]), avr_rgb(src[0 + 160], src[1 + 160]));
			dst += 2;
			src++;
		}
		dst[0] = avr_rgb(src[0], src[0 + 160]);
		dst[1] = 0;
		write_byte_block(vram_addr, vramBuffer, 320 * 2); 
		vram_addr += (320 * 2);

		src++; 
	}

	// bottom 2 lines
	dst = (WORD *)vramBuffer;
	for(x = 0; x < 159; x++){
		dst[0] = src[0];
		dst[1] = avr_rgb(src[0], src[1]); 
		dst += 2;
		src++;
	}
	dst[0] = src[0];
	dst[1] = 0;	     // right edge to BLACK
	write_byte_block(vram_addr, vramBuffer, 320 * 2); 
	vram_addr += (320 * 2);

	// next line
	dst = (WORD *)vramBuffer;
	for(x = 0; x < 160; x++){
		dst[0] = 0;
		dst[1] = 0;
		dst += 2;
	}
	write_byte_block(vram_addr, vramBuffer, 320 * 2); 
	vram_addr += (320 * 2);

}


/*-------------------------------------------------------------------
	calcurate average RGB
-------------------------------------------------------------------*/

WORD avr_rgb(WORD rgb1, WORD rgb2)
{
	WORD r, g, b;

	r = (((rgb1 & 0xf800)>>1) + ((rgb1 & 0xf800)>>1)) & 0xf800;
	g = (((rgb1 & 0x07e0) + (rgb2 & 0x07e0)) >> 1) & 0x07e0;
	b = (((rgb1 & 0x001f) + (rgb2 & 0x001f)) >> 1) & 0x001f;

	return  r|g|b ;
}


// *************************************************************************
// *************************************************************************
// Section:  SD Card operation 
// *************************************************************************
// *************************************************************************

#define	PLAY_SKIP_FRAMES	6
#define	RECORD_SKIP_FRAMES	20

/*========================================================================
	SD play (read from CAPTURE.DAT)
========================================================================*/

BYTE SD_Play(void)
{
	FATFS	fs;
	FIL	    fin;
	UINT    cnt;
	BYTE	c, *bp;
	BYTE	skip;

	f_mount(0, &fs);
	if(f_open(&fin, "CAPTURE.DAT", FA_READ) != FR_OK){
		return 1;
	}

	// write to PIP
	select_display_layer(MAIN_LAYER);
	vram_addr = PIP_VRAM_ADR;
	vram_sw = PIP_LAYER;
	
	for(;;){

		for(skip = 0; skip < PLAY_SKIP_FRAMES; skip++){
			bp = frameBuffer;
			while(bp < frameBuffer+FRMBFSZ){
				if(f_read(&fin, &c, 1, &cnt) != FR_OK){
					goto error_exit;		
				}
				*bp++ = c;
				if(c == 0xFF){
					if(f_read(&fin, &c, 1, &cnt) != FR_OK){
						goto error_exit;		
					}
					if(c == 0xD9){
						*bp++ = 0xd9;
						break;
					}else{
						*bp++ = c;
					}
				}
			}
		}

		frame_bp = frameBuffer;
		if(jd_prepare(&jdec, image_in_func, tjpgd_pool, sizeof(tjpgd_pool), NULL) == JDR_OK){
			jd_decomp(&jdec, lcd_out_func, 0);
		}

		// toggle display layer
		if(vram_sw == MAIN_LAYER){
			select_display_layer(MAIN_LAYER);
			vram_sw = PIP_LAYER;
			vram_addr = PIP_VRAM_ADR;
		}else{
			select_display_layer(PIP_LAYER);
			vram_sw = MAIN_LAYER;
			vram_addr = MAIN_VRAM_ADR;
		}
	}

error_exit:
	f_close(&fin);
	f_mount(0, NULL);
	return 0;
}


/*========================================================================
	SD record (write to CAPTURE.DAT)
========================================================================*/

BOOL    SD_Record(void)
{
	BYTE	maxformat, n;
	BYTE	*sp;
	DWORD	size;
	FATFS	fs;
	FIL	fout;
	UINT cnt;

	// support mjpg format?
	maxformat = USBHostUVCGetFormatCount();
	for(n = 0; n < maxformat; n++){
		if(USBHostUVCGetFormat(n) == FMT_MJPEG){
			break;
		}
	}
	if(n >= maxformat){
		return UVC_UNSUPPORTED_FORMAT;
	}

	// support QVGA ?
	if(USBHostUVCSetFrame(n, QQVGA_WIDTH, QQVGA_HEIGHT) == UVC_UNSUPPORTED_RESOLUTION){
		return UVC_UNSUPPORTED_RESOLUTION;
	}

	f_mount(0, &fs);
	if(f_open(&fout, "CAPTURE.DAT", FA_CREATE_ALWAYS | FA_WRITE) != FR_OK){
		return 1;
	}

	// reset frame buffer pointer
	frame_wp = frame_sp = frameBuffer;
	frame_bytes = frame_size = 0;
	frame_skip = RECORD_SKIP_FRAMES;
	queuePushIndex = queuePopIndex = 0;
	for(n = 0; n < 4; n++) frameQueue[n].frame_valid = 0;

	// Isochronous read, set call back function.
	ISOC_READ_func = receive_frame_data;

	// capture start
	if(USBHostUVCStartFrameCapturing() == UVC_FAIL){
		return UVC_FAIL;
	}

	for(;;){
		// wait for received one frame 
		while(frameQueue[queuePopIndex].frame_valid == 0);

		sp = (BYTE *)frameQueue[queuePopIndex].frame_sp;
		size = frameQueue[queuePopIndex].frame_size;

		// one frame SD card write
		// ring over?
		if((sp + size) > (frameBuffer + FRMBFSZ)){
			if(f_write(&fout, sp, (frameBuffer + FRMBFSZ) - sp, &cnt) != FR_OK){
				goto error_exit;
			}		
			if(f_write(&fout, frameBuffer, (sp + size) - (frameBuffer + FRMBFSZ), &cnt) != FR_OK){
				goto error_exit;
			}		
		}else{
			if(f_write(&fout, sp, size, &cnt) != FR_OK){
				goto error_exit;
			}
		}		

		// update bytes
		IEC1CLR = 0x02000000;	// bit 25 USB
		frame_bytes -= frameQueue[queuePopIndex].frame_size;
		IEC1SET = 0x02000000;	// bit 25 USB
		frameQueue[queuePopIndex].frame_valid = 0;
		queuePopIndex++;
		queuePopIndex &= QUEUE_MASK;

	}

error_exit:
	f_close(&fout);
	f_mount(0, NULL);

	// Stop Frame Capture
	USBHostUVCStopFrameCapturing();

	// disable call back
	ISOC_READ_func = NULL;

	return UVC_SUCCESS;
}


/*========================================================================
	PhotoFrame (read from PHOTO/IMGxxxxx.JPG)
========================================================================*/

BYTE PhotoFrame(void)
{
	FATFS	fs;
	FIL	    fin;
	UINT    cnt;
	BYTE	c, *bp;
	BYTE	skip;

	// mount FatFs
	f_mount(0, &fs);


	// change dir to PHOTO

	// search jpeg file


	// f_open and display


	if(f_open(&fin, "CAPTURE.DAT", FA_READ) != FR_OK){
		return 1;
	}

	// write to PIP
	select_display_layer(MAIN_LAYER);
	vram_addr = PIP_VRAM_ADR;
	vram_sw = PIP_LAYER;
	
	for(;;){

		for(skip = 0; skip < PLAY_SKIP_FRAMES; skip++){
			bp = frameBuffer;
			while(bp < frameBuffer+FRMBFSZ){
				if(f_read(&fin, &c, 1, &cnt) != FR_OK){
					goto error_exit;		
				}
				*bp++ = c;
				if(c == 0xFF){
					if(f_read(&fin, &c, 1, &cnt) != FR_OK){
						goto error_exit;		
					}
					if(c == 0xD9){
						*bp++ = 0xd9;
						break;
					}else{
						*bp++ = c;
					}
				}
			}
		}

		frame_bp = frameBuffer;
		if(jd_prepare(&jdec, image_in_func, tjpgd_pool, sizeof(tjpgd_pool), NULL) == JDR_OK){
			jd_decomp(&jdec, lcd_out_func, 0);
		}

		// toggle display layer
		if(vram_sw == MAIN_LAYER){
			select_display_layer(MAIN_LAYER);
			vram_sw = PIP_LAYER;
			vram_addr = PIP_VRAM_ADR;
		}else{
			select_display_layer(PIP_LAYER);
			vram_sw = MAIN_LAYER;
			vram_addr = MAIN_VRAM_ADR;
		}
	}

error_exit:
	f_close(&fin);
	f_mount(0, NULL);
	return 0;
}


// *************************************************************************
// *************************************************************************
// Section:  call back functions 
// *************************************************************************
// *************************************************************************

/*========================================================================
	jpgd call back input function
========================================================================*/

UINT image_in_func (JDEC* jd, BYTE* buff, UINT nbyte)
{
    if (buff) {
        /* Read bytes from frameBuffer */
		memcpy(buff, frame_bp, nbyte);
		frame_bp += nbyte;
		return nbyte; 
    } else {
        /* Skip read bytes from frameBuffer */
		frame_bp += nbyte;
		return nbyte;
    }
}


/*========================================================================
	jpgd call back output function
========================================================================*/

UINT lcd_out_func (JDEC* jd, void* bitmap, JRECT* rect)
{
    BYTE *src;
	long dst;
    UINT y, bws, bwd;


    // Copy the decompressed RGB rectanglar to the vramBuffer (assuming RGB565 cfg) 
	src = (BYTE*)bitmap;
 	dst = vram_addr + 2 * (rect->top * 320 + rect->left);

 	bws = 2 * (rect->right - rect->left + 1);
 	bwd = 2 * 320;

 	for (y = rect->top; y <= rect->bottom; y++) {
		write_byte_block(dst, src, bws);
		//next line
  	    src += bws;
		dst += bwd;
  	}

	return 1;
}


/*========================================================================
	UVC Isochronous transfers call back function
========================================================================*/

void	receive_frame_data(BYTE *data, DWORD size)
{
	DWORD length, wlen;
	BYTE *dp;

	// skip short packet
	if(size < HEADER_LEN){
		return; 
	}

	// during skip ? 
	if(frame_skip){	
		// Is data frame end? 
		if((data[1] & 2) == 2){
			frame_skip--; // skip end.
			frame_wp = frame_sp;	// reset write point to frame start.
		}
		// do nothing.
		return;
	}

	length = size - HEADER_LEN;
	dp = data + HEADER_LEN;

	// does frameBuffer not enough space?
	if((frame_bytes + length) > FRMBFSZ){
		//skip_frames++;
		// discard now frame
		frame_skip = 1;
		// update bytes
		frame_bytes -= frame_size;
		// clear frame size;
		frame_size = 0;
		return;	
	}

	// ring over ?
	if((frame_wp - frameBuffer) + length >= FRMBFSZ){
		wlen = FRMBFSZ - (frame_wp - frameBuffer);
		memcpy((void *)frame_wp, dp, wlen);
		frame_wp = frameBuffer;  	
		frame_bytes += wlen;
		frame_size += wlen;
		dp += wlen;
		length -= wlen;
	}

	// left copy	
	if(length){
		memcpy((void *)frame_wp, dp, length);
		frame_wp += length;
		frame_bytes += length;
		frame_size += length;
	}

	// copyed frame end, update queu and frame_sp
	if((data[1] & 2) == 2){
		if(frameQueue[queuePushIndex].frame_valid == 0){
			frameQueue[queuePushIndex].frame_valid = 1;
			frameQueue[queuePushIndex].frame_sp = frame_sp;
			frameQueue[queuePushIndex].frame_size = frame_size;
			queuePushIndex++;
			queuePushIndex &= QUEUE_MASK;
		}
		// set next frame start
		frame_sp = frame_wp;
		frame_size = 0;
	}	

}



/*** end of display.c ************************************************************/

#endif	// #if 0