// HardwareProfile.h

#ifndef _HARDWAREPROFILE_H_
#define _HARDWAREPROFILE_H_

// Drive recorder was used by REPIC32SD board.
#define	REPIC32SD_BOARD

#if defined (__C30__)	// PIC24FJ64GB002/PIC24FJ256GB106
    // Various clock values
    #define GetSystemClock()            32000000UL
    #define GetPeripheralClock()        (GetSystemClock())
    #define GetInstructionClock()       (GetSystemClock() / 2)

#elif defined( __PIC32MX__)
	#define USE_USB_PLL
    //#define USB_A0_SILICON_WORK_AROUND
	#if defined (__32MX220F032B__)
		#define	RUN_AT_40MHz
	#elif defined (__32MX695F512H__)
    	#define RUN_AT_80MHZ
	#else
		#error "Not found PIC32 processor"
	#endif

    // Various clock values
    #if defined(RUN_AT_24MHZ)
        #define GetSystemClock()            24000000UL
        #define GetPeripheralClock()        24000000UL
        #define GetInstructionClock()       24000000UL 
    #elif defined(RUN_AT_40MHZ)
        #define GetSystemClock()            40000000UL
        #define GetPeripheralClock()        40000000UL
        #define GetInstructionClock()       40000000UL 
    #elif defined(RUN_AT_48MHZ)
        #define GetSystemClock()            48000000UL
        #define GetPeripheralClock()        48000000UL
        #define GetInstructionClock()       48000000UL 
    #elif defined(RUN_AT_60MHZ)    
        #define GetSystemClock()            60000000UL
        #define GetPeripheralClock()        60000000UL  // Will be divided down
        #define GetInstructionClock()       60000000UL 
    #elif defined(RUN_AT_80MHZ)    
        #define GetSystemClock()            80000000UL
        #define GetPeripheralClock()        80000000UL  // Will be divided down
        #define GetInstructionClock()       80000000UL 
    #else
        #error "Undefined PIC32 clock speeds"
    #endif        
#else
        #error "Undefined processor family"
#endif

// Define the baud rate constants
//#define BAUDRATE2       57600 //19200
#define BAUDRATE2       115200 //19200
#define BRG_DIV2        4 //16
#define BRGH2           1 //0

#define DEMO_TIMEOUT_LIMIT  0xF000

#if defined(__PIC24F__) || defined(__PIC24H__)
    #include <p24fxxxx.h>
    //#include <uart2.h>
#elif defined(__PIC32MX__)
    #include <p32xxxx.h>
    #include <plib.h>
    //#include <uart2.h>
#else
	#error "Undefined processor family"
#endif

#include "uart2.h"

/*******************************************************************/
/******** MDD File System selection options ************************/
/*******************************************************************/
    #define USE_SD_INTERFACE_WITH_SPI
    #define USE_PIC32
    #define USE_32BIT
	//  #define	USE_FSIO

#ifdef USE_FSIO
	// SPI frequency 20MHz
    #define SPI_FREQUENCY			(20000000)

	// SD card chip select
	#define SD_CS				PORTGbits.RG9	// chip select
    #define SD_CS_TRIS			TRISGbits.TRISG9
    
	// SD card slot in detect
    #define SD_CD				PORTBbits.RB5	// slotin detect
    #define SD_CD_TRIS			TRISBbits.TRISB5
    
	// SD Card write protect detect
    #define SD_WE				PORTBbits.RB4	// card write enable detect
    #define SD_WE_TRIS			TRISBbits.TRISB4
 
    // Registers for the SPI module you want to use
    #define SPICON1				SPI2CON
    #define SPISTAT				SPI2STAT
    #define SPIBUF				SPI2BUF
    #define SPISTAT_RBF			SPI2STATbits.SPIRBF
    #define SPICON1bits			SPI2CONbits
    #define SPISTATbits			SPI2STATbits
    #define SPIENABLE           SPI2CONbits.ON
    #define SPIBRG			    SPI2BRG
 
    // Tris pins for SCK/SDI/SDO lines
    #define SPICLOCK			TRISGbits.TRISG6
    #define SPIOUT			    TRISGbits.TRISG8
    #define SPIIN				TRISGbits.TRISG7

    #define putcSPI             putcSPI2
    #define getcSPI             getcSPI2
    #define OpenSPI(config1, config2)   OpenSPI2(config1, config2)
	#define SPI_START_CFG_1     (PRI_PRESCAL_64_1 | SEC_PRESCAL_8_1 | MASTER_ENABLE_ON | SPI_CKE_ON | SPI_SMP_ON)
    #define SPI_START_CFG_2     (SPI_ENABLE)
#endif

#endif  // _HARDWAREPROFILE_H_
